function TDA_kernel(AOperation,InputParameter)
%restpro_batch
% EpiDicomtoNifti
%     InputParameter.EpiDicomToNifti.InDirFunRaw;
%     InputParameter.EpiDicomToNifti.OutDirFunImg;
% T1DicomToNifti
%      InputParameter.T1DicomToNifti.InDirT1Raw;
%      InputParameter.T1DicomToNifti.OutDirT1Img;
% Remove First Time Points
%     InputParameter.RemoveFirstTimePoints.InDirFunImg
%     InputParameter.RemoveFirstTimePoints.OutDirFunImg
%     InputParameter.RemoveFirstTimePoints.TimePointsAmount
% Slice Timing
%     InputParameter.SliceTiming.InDirFunImg;
%     InputParameter.SliceTiming.OutDirFunImg;
%     InputParameter.SliceTiming.SliceNumber;
%     InputParameter.SliceTiming.SliceOrder;
%     InputParameter.SliceTiming.ReferenceSlice;
%     InputParameter.SliceTiming.TR;
% Realign
%     InputParameter.Realign.InDirFunImg;
%     InputParameter.Realign.OutDirFunImg;
%     InputParameter.Realign.RealignParameterDir;
% ReorientFunBeforeCoreg
%     InputParameter.ReorientFunBeforeCoreg.RealignParameterDir
%     InputParameter.ReorientFunBeforeCoreg.OutFodr_ReorientMat
% ReorientT1BeforeCoreg
%     InputParameter.ReorientT1BeforeCoreg.InDirT1Img
%     InputParameter.ReorientT1BeforeCoreg.OutFodr_ReorientMat
% NormalizeEpi
%     InputParameter.Normalize.EPI.InDirFunImg;
%     InputParameter.Normalize.EPI.OutDirFunImg;
%     InputParameter.Normalize.EPI.InDirRealignParameter;
%     InputParameter.Normalize.EPI.InFodrChekNormPic
%     InputParameter.Normalize.EPI.BoundingBox;
%     InputParameter.Normalize.EPI.VoxSize;
% NormalizeSeg_Sym
%     InputParameter.Normalize.Seg_Sym.InDirFunImg;
%     InputParameter.Normalize.Seg_Sym.OutDirFunImg;
%     InputParameter.Normalize.Seg_Sym.InDirT1Img;
%     InputParameter.Normalize.Seg_Sym.BoundingBox;
%     InputParameter.Normalize.Seg_Sym.VoxSize; 
%     InputParameter.Normalize.Seg_Sym.AffineRegularisation;
%     InputParameter.Normalize.Seg_Sym.InFodrChekNormPic;
%     InputParameter.Normalize.Seg_Sym.InDirRealignParameter;
% Normalize_newsegment_dartel
%     InputParameter.Normalize.dartel.InDirFunImg;
%     InputParameter.Normalize.dartel.InDirT1Img;
%     InputParameter.Normalize.dartel.InDirRealignParameter;
%     InputParameter.Normalize.dartel.OutDirFunImg;
%     InputParameter.Normalize.dartel.OutDirT1NewSegment;
%     InputParameter.Normalize.dartel.OutDirT1CoregisterFun;
%     InputParameter.Normalize.dartel.InFodrChekNormPic;
%     InputParameter.Normalize.dartel.BoundingBox;
%     InputParameter.Normalize.dartel.VoxSize;
%     InputParameter.Normalize.dartel.AffineRegularisation;
% T1CoregisterFun
%     InputParameter.T1CoregisterFun.InDirT1Img;
%     InputParameter.T1CoregisterFun.InDirRealignParameter;
%     InputParameter.T1CoregisterFun.OutDirT1CoregisterFun;
% ReorientT1AfterCoreg 
%     InputParameter.ReorientT1AfterCoreg.InDirT1Coregister;
%     InputParameter.ReorientT1AfterCoreg.OutFodr_ReorientMat;
% T1Segment 
%     InputParameter.Segment.InDirT1;
%     InputParameter.Segment.OutDirT1Segment;
%     InputParameter.AffineRegularisation;
% NewSegment
%     InputParameter.NewSegment.InDirT1;
%     InputParameter.NewSegment.OutDirT1NewSegment;
%     InputParameter.NewSegment.Parameter.AffineRegularisation;    
% VBM_NewSegment   
%     [vbm_prefix_str,vbm_rsult_fodrnam]= get_vbm_rsult_nam()
%     InputParameter.VBM_NewSegment.InDirT1
%     InputParameter.VBM_NewSegment.OutDirT1NewSegment
%     InputParameter.VBM_NewSegment.vbm_outfodr
%     InputParameter.VBM_NewSegment.vbm_outfodr.[mw_grey]
%     InputParameter.VBM_NewSegment.vbm_outfodr.[mw_white]
%     InputParameter.VBM_NewSegment.vbm_outfodr.[w_grey]
%     InputParameter.VBM_NewSegment.vbm_outfodr.[w_white]
%     InputParameter.VBM_NewSegment.Parameter.AffineRegularisation  'mni';  European brains (mni); 'eastern'; East Asian brains (eastern)
%     InputParameter.VBM_NewSegment.IsSmooth  [1] or [0]
%     InputParameter.VBM_NewSegment.SmoothFWHM
% NormalizeSeg
%     InputParameter.NormalizeSeg.InDirFunImg;
%     InputParameter.NormalizeSeg.OutDirFunImg;
%     InputParameter.NormalizeSeg.InDirT1Seg;
%     InputParameter.NormalizeSeg.InFodrChekNormPic;
%     InputParameter.NormalizeSeg.BoundingBox;
%     InputParameter.NormalizeSeg.VoxSize;
% NormalizeNewSeg
%      InputParameter.NormalizeNewSeg.InDir_Img;
%      InputParameter.NormalizeNewSeg.OutDir_Img;
%      InputParameter.NormalizeNewSeg.InDir_NewT1Seg;
%      InputParameter.NormalizeNewSeg.outfodr_ChekNorm;
%      InputParameter.NormalizeNewSeg.BoundingBox;
%      InputParameter.NormalizeNewSeg.VoxSize;
% Smooth
%     InputParameter.Smooth.Gaussian.InDirFunImg;
%     InputParameter.Smooth.Gaussian.OutDirFunImg;
%     InputParameter.Smooth.Gaussian.FWHM;
% Detrend
%     InputParameter.Detrend.InDirFunImg;
%     InputParameter.Detrend.OutDirFunImg;
%     InputParameter.Detrend.CutNumber;
% Filter
%     InputParameter.Filter.InDirFunImg;
%     InputParameter.Filter.OutDirFunImg;
%     InputParameter.Filter.InFileMask;
%     InputParameter.Filter.SamplePeriod;
%     InputParameter.Filter.LowPass_HighCutoff;
%     InputParameter.Filter.HighPass_LowCutoff;
%     InputParameter.Filter.IsAddMeanBack;
%     InputParameter.Filter.CutNumber;
% RegressOutCovariates
%     InputParameter.RegressOutCovariates.InDirFunImg;
%     InputParameter.RegressOutCovariates.OutDirFunImg;
%     InputParameter.RegressOutCovariates.OutDirCov;
%     InputParameter.RegressOutCovariates.IsWholeBrain
%     InputParameter.RegressOutCovariates.IsCSF
%     InputParameter.RegressOutCovariates.IsWhiteMatter
%     InputParameter.RegressOutCovariates.IsHeadMotion_Rigidbody6
%     InputParameter.RegressOutCovariates.IsHeadMotion_Friston24
%     InputParameter.RegressOutCovariates.IsOtherCovariatesROI
%     InputParameter.RegressOutCovariates.InDirRealignParameter
%     InputParameter.RegressOutCovariates.OtherCovariatesROIList
%     InputParameter.RegressOutCovariates.IsRemoveIntercept;
%     InputParameter.RegressOutCovariates.PolynomialTrend
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201407
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com

%  Modified by Li Zi-Qi and Jia Xi-Ze 191113: add Version compatibility functions and Fixed the Save Clusters bug.
%  Shirui technology co., LTD
%  Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%  Modified by Sun Jia-Wei 200327:add dynamic metrics 






set_spm_path('default');

    switch upper(AOperation)
        case 'EPIDICOMTONIFTI' %EPI Dicom to Nifti
            run_EpiDicomToNifti(InputParameter);
       case 'T1DICOMTONIFTI' %T1DicomToNifti
            run_T1DicomToNifti(InputParameter);
        case 'REMOVEFIRSTTIMEPOINTS' %Remove First Time Points
            run_RemoveFirstTimePoints(InputParameter);
        case 'SLICETIMING' %Slice Timing
            run_SliceTiming(InputParameter);
        case 'REALIGN' %Realign
            run_Realign(InputParameter);
        case 'REORIENTFUNBEFORECOREG'%ReorientFunBeforeCoreg
            run_ReorientFunBeforeCoreg(InputParameter);
        case 'NORMALIZEEPI' %NormalizeEpi
            run_NormalizeEPI(InputParameter);
        case upper(get_RunStr('NormalizeSymSeg'))
            run_NormalizeSeg_Sym(InputParameter);
        case upper('NormalizeNewSeg_dartel')
            run_Normalize_newsegment_dartel(InputParameter);
        case 'REORIENTT1BEFORECOREG' %ReorientT1BeforeCoreg
            run_ReorientT1BeforeCoreg(InputParameter);
        case 'T1COREGISTERFUN' %T1CoregisterFun
            run_T1CoregisterFun(InputParameter);
        case 'REORIENTT1AFTERCOREG' %ReorientT1AfterCoreg
            run_ReorientT1AfterCoreg(InputParameter);
        case 'T1SEGMENT' %T1Segment
            run_T1Segment(InputParameter);
        case 'NEWSEGMENT' %NewSegment
            run_NewSegment(InputParameter);
        case 'VBM_NEWSEGMENT' %VBM_NewSegment
            run_VBM_NewSegment(InputParameter);
        case 'NORMALIZESEG' %NormalizeSeg
            run_NormalizeSeg(InputParameter);
        case 'NORMALIZENEWSEG'%NormalizeNewSeg
            run_NormalizeNewSeg(InputParameter);
        case 'SMOOTH' %Smooth
            run_Smooth(InputParameter);
        case 'DETREND' %Detrend
            run_Detrend(InputParameter);
        case 'FILTER' %Filter
            run_Filter(InputParameter);
        case 'REGRESSOUTCOVARIATES' %RegressOutCovariates
            run_RegressOutCovariates(InputParameter);
        case 'DYALFF' %Alff
            run_dyALFF(InputParameter); 
        case 'DYFALFF' %fALFF
            run_dyfALFF(InputParameter);
        case 'DYPERAF' %PerAF
            run_dyPerAF(InputParameter);
        case 'DYREHO' %ReHo
            run_dyReHo(InputParameter);
        case 'DYDC' %DC
            run_dyDC(InputParameter);   
        case 'DYFC' %FC
            run_dyFC(InputParameter);
        case 'DYGSCORR' % Gscorr
            run_dyGSCorr(InputParameter);
        case 'DYVMHC' %Vmhc
            run_dyVMHC(InputParameter);
        case 'DYCONCOR' %concordance
            run_dyConcor(InputParameter);
            

        otherwise
            error('error usage for restpro_run!');
            


    end
end

function run_EpiDicomToNifti(InputParameter)
indir_FunRaw=InputParameter.EpiDicomToNifti.InDirFunImg;
outdir_FunImg=InputParameter.EpiDicomToNifti.OutDirFunImg;

indir_Dicom2Nifti(indir_FunRaw,outdir_FunImg);
end


function run_T1DicomToNifti(InputParameter)
indir_T1Raw = InputParameter.T1DicomToNifti.InDirT1Img;
outdir_T1Img = InputParameter.T1DicomToNifti.OutDirT1Img;

indir_Dicom2Nifti(indir_T1Raw,outdir_T1Img);

end

function run_RemoveFirstTimePoints(InputParameter)
    indir_FunImg=InputParameter.RemoveFirstTimePoints.InDirFunImg;
    outdir_FunImg=InputParameter.RemoveFirstTimePoints.OutDirFunImg;
    TimePointsAmount=InputParameter.RemoveFirstTimePoints.TimePointsAmount;
    
    indir_RmFirstTimePoints(indir_FunImg,outdir_FunImg,TimePointsAmount);
end



function run_SliceTiming(InputParameter)
    indir_FunImg=InputParameter.SliceTiming.InDirFunImg;
    outdir_FunImg=InputParameter.SliceTiming.OutDirFunImg;
    Parameter.SliceNumber=InputParameter.SliceTiming.SliceNumber;
    Parameter.SliceOrder=InputParameter.SliceTiming.SliceOrder;
    Parameter.ReferenceSlice=InputParameter.SliceTiming.ReferenceSlice;
    Parameter.TR=InputParameter.SliceTiming.TR;
    
    indir_SliceTiming(indir_FunImg,outdir_FunImg,Parameter);
end



function run_Realign(InputParameter)
    indir_FunImg=InputParameter.Realign.InDirFunImg;
    outdir_FunImg=InputParameter.Realign.OutDirFunImg;
    outdir_RealignParameter=InputParameter.Realign.RealignParameterDir;
    
    indir_Realign(indir_FunImg,outdir_FunImg,outdir_RealignParameter);
end


function run_ReorientFunBeforeCoreg(InputParameter)

    indir_RealignParameter=InputParameter.ReorientFunBeforeCoreg.RealignParameterDir;
    outFodr_ReorientMat=InputParameter.ReorientFunBeforeCoreg.OutFodr_ReorientMat;
        
    Parameter.ReorientMatPrefix='ReorientFunBeforeCoreg';

    indir_FunReorientImage(indir_RealignParameter,outFodr_ReorientMat,Parameter);
end

function run_NormalizeEPI(InputParameter)
    indir_FunImg=InputParameter.Normalize.EPI.InDirFunImg;
    outdir_FunImg=InputParameter.Normalize.EPI.OutDirFunImg;
    indir_RealignParameter=InputParameter.Normalize.EPI.InDirRealignParameter;
    outfodr_ChekNorm=InputParameter.Normalize.EPI.InFodrChekNormPic;
    
    Parameter.BoundingBox=InputParameter.Normalize.EPI.BoundingBox;
    Parameter.VoxSize=InputParameter.Normalize.EPI.VoxSize;
    
    indir_NormalizeEPI(indir_FunImg,indir_RealignParameter,outdir_FunImg,outfodr_ChekNorm,Parameter);
end


function run_NormalizeSeg_Sym(InputParameter)
   
ori_funimg=InputParameter.Normalize.Seg_Sym.InDirFunImg;
normsym_funimg=InputParameter.Normalize.Seg_Sym.OutDirFunImg;
ori_t1Img=InputParameter.Normalize.Seg_Sym.InDirT1Img;
realignpara=InputParameter.Normalize.Seg_Sym.InDirRealignParameter;
ChekNorm=InputParameter.Normalize.Seg_Sym.InFodrChekNormPic;
Parameter.BoundingBox=InputParameter.Normalize.Seg_Sym.BoundingBox;
Parameter.VoxSize=InputParameter.Normalize.Seg_Sym.VoxSize;
Parameter.AffineRegularisation=InputParameter.Normalize.Seg_Sym.AffineRegularisation;

indir_NormalizeSeg_sym_module(ori_funimg,normsym_funimg,ori_t1Img,realignpara,ChekNorm,Parameter)
end


function run_Normalize_newsegment_dartel(InputParameter)
indir_epi_img          =InputParameter.Normalize.dartel.InDirFunImg;
indir_t1_img           =InputParameter.Normalize.dartel.InDirT1Img;
indir_realignparameter =InputParameter.Normalize.dartel.InDirRealignParameter;
outdir_normalized_epi  =InputParameter.Normalize.dartel.OutDirFunImg;
outdir_t1_new_segment  =InputParameter.Normalize.dartel.OutDirT1NewSegment;
outdir_t1_coregister   =InputParameter.Normalize.dartel.OutDirT1CoregisterFun;
outfolder_Template     =InputParameter.Normalize.dartel.OutFodrTemplate;
output_folder_for_check=InputParameter.Normalize.dartel.InFodrChekNormPic;


parameters.bb          =InputParameter.Normalize.dartel.BoundingBox;
parameters.vox         =InputParameter.Normalize.dartel.VoxSize;
parameters.AffineRegularisation=InputParameter.Normalize.dartel.AffineRegularisation;

indir_Normalize_newsegment_dartel_module...
        (indir_epi_img,indir_t1_img,indir_realignparameter,...
        outdir_normalized_epi,outdir_t1_new_segment,outdir_t1_coregister,...
         parameters,output_folder_for_check,outfolder_Template)
end


function  run_ReorientT1BeforeCoreg(InputParameter)
    indir_T1=InputParameter.ReorientT1BeforeCoreg.InDirT1Img;
    outFodr_ReorientMat=InputParameter.ReorientT1BeforeCoreg.OutFodr_ReorientMat;
    Parameter.ReorientMatPrefix='ReorientT1BeforeCoreg';   

    indir_T1ReorientImage(indir_T1,outFodr_ReorientMat,Parameter)
end

function  run_T1CoregisterFun(InputParameter)
    indir_T1Img=InputParameter.T1CoregisterFun.InDirT1Img;
    indir_RealignParameter=InputParameter.T1CoregisterFun.InDirRealignParameter;
    outdir_T1CoregisterFun=InputParameter.T1CoregisterFun.OutDirT1CoregisterFun;
    
    indir_Coregister(indir_T1Img,indir_RealignParameter,outdir_T1CoregisterFun);
end

function run_ReorientT1AfterCoreg(InputParameter)
indir_T1 =  InputParameter.ReorientT1AfterCoreg.InDirT1Coregister;
outFodr_ReorientMat =  InputParameter.ReorientT1AfterCoreg.OutFodr_ReorientMat;
Parameter.ReorientMatPrefix = 'ReorientT1AfterCoreg';

indir_T1ReorientImage(indir_T1,outFodr_ReorientMat,Parameter);
end

function run_T1Segment(InputParameter)
    indir_T1=InputParameter.Segment.InDirT1;
    outdir_T1Segment=InputParameter.Segment.OutDirT1Segment;
    Parameter.AffineRegularisation=InputParameter.AffineRegularisation;
    
    indir_Segmentation(indir_T1,outdir_T1Segment,Parameter);
end

function run_NewSegment(InputParameter)
    indir_t1=InputParameter.NewSegment.InDirT1;
    outdir_new_segment=InputParameter.NewSegment.OutDirT1NewSegment;
%     Parameter.AffineRegularisation=InputParameter.NewSegment.Parameter.AffineRegularisation;    
    Parameter=InputParameter.NewSegment.Parameter;
    indir_NewSegment(indir_t1,outdir_new_segment,Parameter);
end

function run_NormalizeSeg(InputParameter)
    indir_FunImg=InputParameter.NormalizeSeg.InDirFunImg;
    outidr_FunImg=InputParameter.NormalizeSeg.OutDirFunImg;
    indir_T1Seg=InputParameter.NormalizeSeg.InDirT1Seg;
    outfodr_ChekNorm=InputParameter.NormalizeSeg.InFodrChekNormPic;
    
    Parameter.BoundingBox=InputParameter.NormalizeSeg.BoundingBox;
    Parameter.VoxSize=InputParameter.NormalizeSeg.VoxSize;
    
    indir_NormalizeSeg(indir_FunImg,outidr_FunImg,indir_T1Seg,outfodr_ChekNorm,Parameter);
end

function run_NormalizeNewSeg(InputParameter)
InDir_Img = InputParameter.NormalizeNewSeg.InDir_Img;
OutDir_Img =InputParameter.NormalizeNewSeg.OutDir_Img;
InDir_NewT1Seg = InputParameter.NormalizeNewSeg.InDir_NewT1Seg;
outfodr_ChekNorm=InputParameter.NormalizeNewSeg.outfodr_ChekNorm;
Parameter.BoundingBox=InputParameter.NormalizeNewSeg.BoundingBox;
Parameter.VoxSize=InputParameter.NormalizeNewSeg.VoxSize;

indir_NormalizeNewSeg(InDir_Img,OutDir_Img,InDir_NewT1Seg,outfodr_ChekNorm,Parameter);
end

function run_Smooth(InputParameter)
    indir_FunImg=InputParameter.Smooth.Gaussian.InDirFunImg;
    outdir_FunImg=InputParameter.Smooth.Gaussian.OutDirFunImg;
    Parameter.FWHM=InputParameter.Smooth.Gaussian.FWHM;
    
    if 3~=length(Parameter.FWHM)
        error('FWHM is not [X X X]');
    end
    
    indir_SPMdefaultSmooth(indir_FunImg,outdir_FunImg,Parameter)
end

function run_Detrend(InputParameter)
 indir_FunImg=InputParameter.Detrend.InDirFunImg;
 outdir_FunImg=InputParameter.Detrend.OutDirFunImg;
 CutNumber=InputParameter.Detrend.CutNumber;
 
 indir_Detrend(indir_FunImg,outdir_FunImg,CutNumber);
end

function run_Filter(InputParameter)

indir_FunImg=InputParameter.Filter.InDirFunImg;
outdir_FunImg=InputParameter.Filter.OutDirFunImg;
infile_Mask=InputParameter.Filter.InFileMask;

Parameter.SamplePeriod=InputParameter.Filter.SamplePeriod;
Parameter.LowPass_HighCutoff=InputParameter.Filter.LowPass_HighCutoff;
Parameter.HighPass_LowCutoff=InputParameter.Filter.HighPass_LowCutoff;
Parameter.IsAddMeanBack=InputParameter.Filter.IsAddMeanBack;
Parameter.CutNumber=InputParameter.Filter.CutNumber;

indir_Filter(indir_FunImg,outdir_FunImg,infile_Mask,Parameter);

end

function run_RegressOutCovariates(InputParameter)
Fun_Indir =InputParameter.RegressOutCovariates.InDirFunImg;
Fun_Outdir =InputParameter.RegressOutCovariates.OutDirFunImg;
Cov_OutDir =InputParameter.RegressOutCovariates.OutDirCov;

Parameter.IsRemoveIntercept=InputParameter.RegressOutCovariates.IsRemoveIntercept;
Parameter.PolynomialTrend=InputParameter.RegressOutCovariates.PolynomialTrend;
Parameter.IsWholeBrain = InputParameter.RegressOutCovariates.IsWholeBrain;
Parameter.IsCSF = InputParameter.RegressOutCovariates.IsCSF;
Parameter.IsWhiteMatter = InputParameter.RegressOutCovariates.IsWhiteMatter;
Parameter.IsOtherCovariatesROI = InputParameter.RegressOutCovariates.IsOtherCovariatesROI;
Parameter.InDirRealignParameter = InputParameter.RegressOutCovariates.InDirRealignParameter;
Parameter.OtherCovariatesROIList = InputParameter.RegressOutCovariates.OtherCovariatesROIList;
Parameter.IsHeadMotion_Friston24= InputParameter.RegressOutCovariates.IsHeadMotion_Friston24; 
Parameter.IsHeadMotion_Rigidbody6 = InputParameter.RegressOutCovariates.IsHeadMotion_Rigidbody6;
% if isfield(InputParameter.RegressOutCovariates,'IsHeadMotion_Rigidbody6')
%       Parameter.IsHeadMotion_Rigidbody6 = InputParameter.RegressOutCovariates.IsHeadMotion_Rigidbody6;
% else
%     Parameter.IsHeadMotion_Rigidbody6=0;
% end
% if isfield(InputParameter.RegressOutCovariates,'IsHeadMotion_Friston24')
%    Parameter.IsHeadMotion_Friston24=InputParameter.RegressOutCovariates.IsHeadMotion_Friston24;
% else

% end
indir_RegressOutCov(Fun_Indir,Fun_Outdir,Cov_OutDir,Parameter);
end

function run_VBM_NewSegment(InputParameter)
% [vbm_prefix_str,vbm_rsult_fodrnam]= get_vbm_rsult_nam()
indir_t1=InputParameter.VBM_NewSegment.InDirT1;
outdir_new_segment=InputParameter.VBM_NewSegment.OutDirT1NewSegment;
vbm_outfodr=InputParameter.VBM_NewSegment.vbm_outfodr;
Parameter=InputParameter.VBM_NewSegment.Parameter;

indir_vbm_using_newsegment(indir_t1,outdir_new_segment,vbm_outfodr,Parameter);

if 1==InputParameter.VBM_NewSegment.IsSmooth
   smooth_FWHM=InputParameter.VBM_NewSegment.SmoothFWHM; 
   smooth_vbm_results(vbm_outfodr,smooth_FWHM);  
end

end


function run_dyALFF(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.HighCutoff = InputParameter.DyALFF.LowPass_HighCutoff;
Parameter.LowCutoff = InputParameter.DyALFF.HighPass_LowCutoff;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyALFF.InDirFunImg;
outfodr_DyALFF = InputParameter.DyALFF.OutDir;

indir_dyALFF_4D(indir_FunImg,outfodr_DyALFF,AMaskFilename,Parameter);
% StandardizedMethod(outfodr_dyALFF,infile_Mask);
end

function run_dyfALFF(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.HighCutoff = InputParameter.DyfALFF.LowPass_HighCutoff;
Parameter.LowCutoff = InputParameter.DyfALFF.HighPass_LowCutoff;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyfALFF.InDirFunImg;
outfodr_DyfALFF = InputParameter.DyfALFF.OutDir;
indir_dyfALFF_4D(indir_FunImg,outfodr_DyfALFF,AMaskFilename,Parameter);

end

function run_dyReHo(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.IsDetrend = InputParameter.IsDetrend;
Parameter.NVoxel = InputParameter.DyReHo.NVoxel;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyReHo.InDirFunImg;
outfodr_DyReHo = InputParameter.DyReHo.OutDir;
indir_dyReHo_4D(indir_FunImg,outfodr_DyReHo,AMaskFilename,Parameter);
end

function run_dyFC(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.ROIDef = InputParameter.DyFC.ROIDef;
Parameter.IsMultipleLabel = InputParameter.DyFC.IsMultipleLabel;
Parameter.IsDetrend = InputParameter.IsDetrend;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyFC.InDirFunImg;
outfodr_DyFC = InputParameter.DyFC.OutDir;
indir_dyFC_4D(indir_FunImg,outfodr_DyFC,AMaskFilename,Parameter)
end

function run_dyPerAF(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyPerAF.InDirFunImg;
outfodr_DyPerAF = InputParameter.DyPerAF.OutDir;
indir_dyPerAF_4D(indir_FunImg, outfodr_DyPerAF, AMaskFilename, Parameter)
end

function run_dyVMHC(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
AMaskFilename = InputParameter.Mask;
Parameter.IsDetrend = InputParameter.IsDetrend;
indir_FunImg = InputParameter.DyVMHC.InDirFunImg;
outfodr_DyVMHC = InputParameter.DyVMHC.OutDir;
indir_dyVMHC_4D(indir_FunImg,outfodr_DyVMHC,AMaskFilename,Parameter)

end

function  run_dyGSCorr(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.ROIDef = InputParameter.DyGSCorr.ROIDef;
Parameter.IsDetrend = InputParameter.IsDetrend;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyGSCorr.InDirFunImg;
outfodr_DyGSCorr = InputParameter.DyGSCorr.OutDir;
indir_dyGSCorr_4D(indir_FunImg,outfodr_DyGSCorr,AMaskFilename,Parameter)

end

function run_dyDC(InputParameter)
Parameter.WindowSize = InputParameter.WindowSize;
Parameter.WindowStep = InputParameter.WindowStep;
Parameter.WindowType = InputParameter.WindowType;
Parameter.SamplePeriod = InputParameter.TR;
Parameter.rThreshold = InputParameter.DyDC.rThreshold;
Parameter.IsDetrend = InputParameter.IsDetrend;
AMaskFilename = InputParameter.Mask;
indir_FunImg = InputParameter.DyDC.InDirFunImg;
outfodr_DyDC = InputParameter.DyDC.OutDir;
indir_dyDC_4D(indir_FunImg,outfodr_DyDC,AMaskFilename,Parameter);

end

function run_dyConcor(InputParameter)
Indir_FunImg =  InputParameter.DyConcor.InDirFunImg;
AMaskFilename = InputParameter.Mask;
Indir.ConALFF = InputParameter.ConALFF.InDirFunImg;
Indir.ConfALFF = InputParameter.ConfALFF.InDirFunImg;
Indir.ConReHo = InputParameter.ConReHo.InDirFunImg;
Indir.ConDC = InputParameter.ConDC.InDirFunImg;
Indir.ConGSCorr = InputParameter.ConGSCorr.InDirFunImg;
Indir.ConVMHC = InputParameter.ConVMHC.InDirFunImg;
outfodr_VoxelWise = InputParameter.DyConcor.VoxelWise;
outfodr_VolumeWise = InputParameter.DyConcor.VolumeWise;
FWHM = InputParameter.DyConcor.FWHM;
indir_dyConcor(Indir_FunImg, Indir, outfodr_VoxelWise, outfodr_VolumeWise, AMaskFilename, FWHM);
end



function [mfolderpath,zfolderpath]= StandardizedMethod(infolder,infile_Mask)
    if ischar(infile_Mask)
        [pathstr, name, ext]=fileparts(infolder);
        mfolderpath=[pathstr filesep get_Prefix('DivideMeanWithinMask') name];
        zfolderpath=[pathstr filesep get_Prefix('CalcZscoreWithinMask') name];
        batch_calc3dimg('DivideMeanWithinMask',infolder,...
                                               mfolderpath,...
                                              infile_Mask);
        batch_calc3dimg('CalcZscoreWithinMask',infolder,...
                                               zfolderpath,...
                                              infile_Mask);
    end
end


function smooth_and_standardized_postprocess_folder(postprocess_folder,smooth_FWHM,infile_Mask)
   [m_postprocess_folder,z_postprocess_folder]=StandardizedMethod(postprocess_folder,infile_Mask);
   
   [pathstr, name, ext]       = fileparts(postprocess_folder);
   [m_pathstr, m_name, m_ext] = fileparts(m_postprocess_folder);
   [z_pathstr, z_name, z_ext] = fileparts(z_postprocess_folder);

    Parameter.FWHM=smooth_FWHM;
   
   s_postprocess_folder =[pathstr filesep get_Postfix('Smooth') name];
   sm_postprocess_folder=[m_pathstr filesep get_Postfix('Smooth') m_name];
   sz_postprocess_folder=[z_pathstr filesep get_Postfix('Smooth') z_name];
   
   inpath_Misc(s_postprocess_folder,'MakeCurrentDir');
   inpath_Misc(sm_postprocess_folder,'MakeCurrentDir');
   inpath_Misc(sz_postprocess_folder,'MakeCurrentDir');
   
   infodr_SPMdefaultSmooth(postprocess_folder,s_postprocess_folder,Parameter);
   infodr_SPMdefaultSmooth(m_postprocess_folder,sm_postprocess_folder,Parameter);
   infodr_SPMdefaultSmooth(z_postprocess_folder,sz_postprocess_folder,Parameter);
end

function smooth_vbm_results(vbm_outfodr,smooth_FWHM)
vbm_outfodr_fieldnames=fieldnames(vbm_outfodr);
output_fodr_amt=length(vbm_outfodr_fieldnames);
Parameter.FWHM=smooth_FWHM;
for fodr_ind=1:output_fodr_amt
    crnt_fieldname=vbm_outfodr_fieldnames{fodr_ind};
    crnt_outfodr_pth=vbm_outfodr.(crnt_fieldname);
    [pathstr, name, ext]=fileparts(crnt_outfodr_pth);
    s_crnt_outfodr_pth=[pathstr filesep 's_' name];
   infodr_SPMdefaultSmooth(crnt_outfodr_pth,s_crnt_outfodr_pth,Parameter);
end
end


