function indir_dyConcor(Indir_FunImg, Indir, outfodr_VoxelWise, outfodr_VolumeWise, AMaskFilename, FWHM)
%-----------------------------------------------------------
%   Written by SUN Jia-Wei 200413.
%   Mail to Authors: jiaweisun0512@163.com
%
[FunPath,FunName] = fileparts(Indir_FunImg);
SubfodrList=dir_NameList(Indir_FunImg);
MetrixName = fieldnames(Indir);
if isempty(outfodr_VoxelWise) && isempty(outfodr_VolumeWise)
    error('can''t select VoxelWise or VolumeWise');
end

for i = 1 : length(MetrixName)
    MetrixDir{i} = eval(['Indir.' MetrixName{i}]);
    [pathstr,mname] = fileparts(MetrixDir{i});
    metrix{i} = mname(1:end-length(FunName)-1);
end

if ~isempty(outfodr_VoxelWise)
    VoxelOutFile = [outfodr_VoxelWise filesep 'TemporalDynamics' filesep 'Concordance_VoxelWise' ];
    inpath_Misc(VoxelOutFile,'MakeCurrentDir');
    if ~isempty(FWHM)
        SmoothIndir = [outfodr_VoxelWise filesep 'TemporalDynamics' filesep 'Concordance_VoxelWise' filesep 'sConcordance_VoxelWise_'];
        SmoothOut = [outfodr_VoxelWise filesep 'TemporalDynamics' filesep 'SConcordance_VoxelWise' ];
        inpath_Misc(SmoothOut,'MakeCurrentDir');
    end
end
if ~isempty(outfodr_VolumeWise)
    VolumeOutFile = [outfodr_VoxelWise filesep 'TemporalDynamics' filesep 'Concordance_VolumeWise' ];
    inpath_Misc(VolumeOutFile,'MakeCurrentDir');
end


for i=1:length(SubfodrList)
    Indir = metrix2dir(MetrixDir, metrix, SubfodrList{i});
    if ~isempty(outfodr_VoxelWise)
        [KendallW] = infodr_KendallW_Images(Indir, AMaskFilename, [VoxelOutFile filesep 'Concordance_VoxelWise_' SubfodrList{i} '.nii']);
        if ~isempty(FWHM)
            jobs{1,1}.spm.spatial{1,1}.smooth.data = {[VoxelOutFile filesep 'Concordance_VoxelWise_' SubfodrList{i} '.nii']};
            jobs{1,1}.spm.spatial{1,1}.smooth.fwhm = str2num(FWHM);
            jobs{1,1}.spm.spatial{1,1}.smooth.dtype = 0;
            jobs{1,1}.spm.spatial{1,1}.smooth.prefix = 'S';
            spm_jobman('run',jobs);
            movefile([SmoothIndir SubfodrList{i} '.nii'],SmoothOut);
        end
    end
    if ~isempty(outfodr_VolumeWise)
        [KendallW] = infodr_KendallW_AcrossImages(Indir, AMaskFilename, [VolumeOutFile filesep 'Concordance_VolumeWise_' SubfodrList{i}]);
    end
end

end


function Indir = metrix2dir(MetrixDir,metrix, Sub)
n = 1;
for i = 1 : length(MetrixDir)
    if ~isempty(MetrixDir{i})
        if strcmpi(metrix{i},'GSCorr') || strcmpi(metrix{i},'VMHC')
            Indir{n} = [MetrixDir{i} filesep 'z' metrix{i} '_' Sub '.nii'];
        elseif strcmpi(metrix{i},'DC')
            Indir{n} = [MetrixDir{i} filesep metrix{i} '_' Sub '_' 'DegreeCentrality_PositiveWeightedSumBrain' '.nii'];
        else
            Indir{n} = [MetrixDir{i} filesep metrix{i} '_' Sub '.nii'];
        end
        n = n+1;
    end
end
end

