function indir_dyPerAF_4D(indir_FunImg, outfodr_DyPerAF, infile_Mask, Parameter)
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201412
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com
%   Shirui technology co., LTD
%   Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China

inpath_Misc(outfodr_DyPerAF, 'MakeCurrentDir');
SubfodrList = dir_NameList(indir_FunImg);
[FunDir, FunName] = fileparts(indir_FunImg);
TDAPath = [outfodr_DyPerAF filesep 'TemporalDynamics' filesep 'TDA_4D' filesep 'PerAF_' FunName];
TDAMPath = [outfodr_DyPerAF filesep 'TemporalDynamics' filesep 'TDA_Metrics' filesep 'PerAF_' FunName];
inpath_Misc(TDAPath, 'MakeCurrentDir');
inpath_Misc(TDAMPath, 'MakeCurrentDir');

if ~isempty(gcp('nocreate'))
    parfor i=1:length(SubfodrList)
        [PSCBrain_AllWindow, Header] = infodr_dyPerAF_4D([indir_FunImg filesep SubfodrList{i}], ...
                     [TDAPath filesep 'PerAF_' SubfodrList{i} '.nii'], ...
                     infile_Mask, Parameter);
        MeanOut = [TDAMPath filesep 'MeanPerAF' filesep 'MeanPerAF_' SubfodrList{i} '.nii'];
        StdOut = [TDAMPath filesep 'StdPerAF' filesep 'StdPerAF_' SubfodrList{i} '.nii'];
        CVOut = [TDAMPath filesep 'CVPerAF' filesep 'CVPerAF_' SubfodrList{i} '.nii'];
        tda_GetTDAMetrics(PSCBrain_AllWindow, Header, MeanOut, StdOut, CVOut);
    end
else
    for i=1:length(SubfodrList)
        [PSCBrain_AllWindow, Header] = infodr_dyPerAF_4D([indir_FunImg filesep SubfodrList{i}], ...
                     [TDAPath filesep 'PerAF_' SubfodrList{i} '.nii'], ...
                     infile_Mask, Parameter);
        MeanOut = [TDAMPath filesep 'MeanPerAF' filesep 'MeanPerAF_' SubfodrList{i} '.nii'];
        StdOut = [TDAMPath filesep 'StdPerAF' filesep 'StdPerAF_' SubfodrList{i} '.nii'];
        CVOut = [TDAMPath filesep 'CVPerAF' filesep 'CVPerAF_' SubfodrList{i} '.nii'];
        tda_GetTDAMetrics(PSCBrain_AllWindow, Header, MeanOut, StdOut, CVOut);
    end
end

end