function handles = LoadParamSet(PaSet,handles)
%-----------------------------------------------------------
%   Written by SUN Jia-Wei 200413.
%   Mail to Authors: jiaweisun0512@163.com
%
handles.WorkPath = PaSet.WorkPath;
handles.TR = PaSet.TR;
handles.EPIPath = PaSet.EPIPath ;
[EPIpathstr,EPIName] = fileparts(handles.EPIPath);
handles.T1Path = PaSet.T1Path;
[T1pathstr,T1Name] = fileparts(handles.T1Path);

handles.D2N.IsD2N = PaSet.IsDicom2Nifti;
handles.D2N.EPI = PaSet.Dicom2Nifti.IsEPI;
handles.D2N.T1 = PaSet.Dicom2Nifti.IsT1;

handles.RemoveTime.IsRemoveTime = PaSet.IsRemoveFirstnTimePoints;
handles.RemoveTime.Time = PaSet.RemoveFirstnTimePoints.Time;

handles.Slice.IsSlice = PaSet.IsSliceTiming;
handles.Slice.SliceRefer = PaSet.SliceTiming.SliceRefer;
handles.Slice.SliceOrder = PaSet.SliceTiming.SliceOreder;
handles.Slice.SliceNumber = PaSet.SliceTiming.SliceNumber;

handles.Realign.IsRealign = PaSet.IsRealign;

handles.Normal.IsNormal = PaSet.IsNormalize;
handles.Normal.Bbox = PaSet.Normalize.Bbox;
handles.Normal.VoxelSize = PaSet.Normalize.VoxelSize;
handles.Normal.People = PaSet.Normalize.People;
handles.Normal.Method = PaSet.Normalize.Method;
handles.Smooth.IsSmooth = PaSet.IsSmooth;
handles.Smooth.FWHM = PaSet.Smooth.fwhm;

handles.Detrend.IsDetrend = PaSet.IsDetrend;

handles.Cov.IsCov = PaSet.IsCovariate;
handles.Cov.IsCovDetrend = PaSet.Covariate.IsCovDetrend;
handles.Cov.IsCovFriston24 = PaSet.Covariate.IsCovFriston24;
handles.Cov.IsCovWM = PaSet.Covariate.IsCovWM;
handles.Cov.IsCovCSF = PaSet.Covariate.IsCovCSF;
handles.Cov.IsCovGlobal = PaSet.Covariate.IsCovGlobal;
handles.Cov.IsAddMeanBack = PaSet.Covariate.IsAddMeanBack;
handles.Cov.IsCovOther = PaSet.Covariate.IsCovOther;
handles.Cov.CovOtherROI = PaSet.Covariate.CovOther;

handles.Filter.IsFilter = PaSet.IsFilter;
handles.Filter.LowPass_HighCut = PaSet.Filter.LowPass_HighCut;
handles.Filter.LowCut_HighPass = PaSet.Filter.LowCut_HighPass; 

handles.DyPara.WinType = PaSet.DynamicParameter.WinType; 
handles.DyPara.WinStep = PaSet.DynamicParameter.WinStep;
handles.DyPara.WinSize = PaSet.DynamicParameter.WinSize;
handles.DyPara.Detrend = PaSet.DynamicParameter.Detrend;
handles.DyMask = PaSet.DynamicParameter.DyMask;

handles.DyALFF.IsALFF = PaSet.IsDynamicALFF;
handles.DyALFF.LowPass_HighCut = PaSet.DynamicALFF.LowPass_HighCut;
handles.DyALFF.LowCut_HighPass = PaSet.DynamicALFF.LowCut_HighPass;

handles.DyfALFF.IsfALFF = PaSet.IsDynamicfALFF;
handles.DyfALFF.LowPass_HighCut = PaSet.DynamicfALFF.LowPass_HighCut;
handles.DyfALFF.LowCut_HighPass = PaSet.DynamicfALFF.LowCut_HighPass;

handles.DyReHo.IsReHo = PaSet.IsDynamicReHo;
handles.DyReHo.Cluster = PaSet.DynamicReHo.Cluster;

handles.DyDC.IsDC = PaSet.IsDynamicDC;
handles.DyDC.rValue = PaSet.DynamicDC.rValue;

handles.DyPerAF.IsPerAF = PaSet.IsDynamicPerAF;


% handles.DyGSCorr.IsGSCorr = PaSet.IsDynamicGSCorr;
% handles.DyGSCorr.Mask = PaSet.DynamicGSCorr.Mask;

handles.DyFC.IsFC = PaSet.IsDynamicFC;
handles.DyFC.FCROIDef = PaSet.DynamicFC.FCROIDef;
handles.DyFC.IsMultiple = PaSet.DynamicFC.IsMultiple;

% handles.DyVMHC.IsVMHC = PaSet.IsDynamicVMHC;
% 
% handles.DyConcor.IsConcor = PaSet.IsDynamicConcor;
% handles.DyConcor.IsVoxelWise = PaSet.DynamicConcor.IsVoxelWise;
% handles.DyConcor.IsVolumeWise = PaSet.DynamicConcor.IsVolumeWise;
% handles.DyConcor.IsALFF = PaSet.DynamicConcor.IsALFF;
% handles.DyConcor.IsfALFF = PaSet.DynamicConcor.IsfALFF;
% handles.DyConcor.IsReHo = PaSet.DynamicConcor.IsReHo;
% handles.DyConcor.IsDC = PaSet.DynamicConcor.IsDC;
% handles.DyConcor.IsGSCorr = PaSet.DynamicConcor.IsGSCorr;
% handles.DyConcor.IsVMHC = PaSet.DynamicConcor.IsVMHC;
% handles.DyConcor.IsSmooth = PaSet.DynamicConcor.IsSmooth;
% handles.DyConcor.FWHM = PaSet.DynamicConcor.fwhm;

set(handles.edit_WorkDir,'String',handles.WorkPath);
if ~isempty(EPIName)
    set(handles.cebx_EPIName,'Value',1);
    set(handles.edit_EPIName,'String',EPIName);
    set(handles.edit_EPIName,'enable','on');
end
if ~isempty(T1Name)
    set(handles.cebx_T1Name,'Value',1);
    set(handles.edit_T1Name,'String',T1Name);
    set(handles.edit_T1Name,'enable','on');
end
set(handles.edit_TR,'String',handles.TR);

set(handles.cebx_D2N,'Value',handles.D2N.IsD2N);
set(handles.cebx_EPI,'Value',handles.D2N.EPI);
set(handles.cebx_T1,'Value',handles.D2N.T1);

set(handles.cebx_RemoveTime,'Value',handles.RemoveTime.IsRemoveTime);
set(handles.edit_RemoveTime,'String',handles.RemoveTime.Time);

set(handles.cebx_Slice,'Value',handles.Slice.IsSlice);
set(handles.edit_SliceRefer,'String',handles.Slice.SliceRefer);
set(handles.edit_SliceOrder,'String',handles.Slice.SliceOrder);
set(handles.edit_SliceNumber,'String',handles.Slice.SliceNumber);

set(handles.cebx_Realign,'Value',handles.Realign.IsRealign);

set(handles.cebx_RemoveTime,'Value',handles.Realign.IsRealign);

set(handles.cebx_Normal,'Value',handles.Normal.IsNormal );
set(handles.edit_Bbox,'String',handles.Normal.Bbox);
set(handles.edit_VoxelSize,'String',handles.Normal.VoxelSize);
switch handles.Normal.Method
    case 'EPI'
        set(handles.rbtn_NorEPI,'Value',1);
        set(handles.rbtn_NorT1New,'Value',0);
        set(handles.rbtn_NorT1Unifi,'Value',0);
        set(handles.rbtn_NorT1Dartel,'Value',0);
        set(handles.rbtn_NorEa,'Visible','off');
        set(handles.rbtn_NorEu,'Visible','off');
    case 'T1New'
        set(handles.rbtn_NorEPI,'Value',0);
        set(handles.rbtn_NorT1New,'Value',1);
        set(handles.rbtn_NorT1Unifi,'Value',0);
        set(handles.rbtn_NorT1Dartel,'Value',0);
        set(handles.rbtn_NorEa,'Visible','on');
        set(handles.rbtn_NorEu,'Visible','on');
    case 'T1Unified'
        set(handles.rbtn_NorEPI,'Value',0);
        set(handles.rbtn_NorT1New,'Value',0);
        set(handles.rbtn_NorT1Unifi,'Value',1);
        set(handles.rbtn_NorT1Dartel,'Value',0);
        set(handles.rbtn_NorEa,'Visible','on');
        set(handles.rbtn_NorEu,'Visible','on');
    case 'T1Dartel'
        set(handles.rbtn_NorEPI,'Value',0);
        set(handles.rbtn_NorT1New,'Value',0);
        set(handles.rbtn_NorT1Unifi,'Value',0);
        set(handles.rbtn_NorT1Dartel,'Value',1);
        set(handles.rbtn_NorEa,'Visible','on');
        set(handles.rbtn_NorEu,'Visible','on');
end
switch handles.Normal.People
    case 'Ea'
        set(handles.rbtn_NorEa,'Value',1);
        set(handles.rbtn_NorEu,'Value',0);
    case 'Eu'
        set(handles.rbtn_NorEa,'Value',0);
        set(handles.rbtn_NorEu,'Value',1);
end

set(handles.cebx_Smooth,'Value',handles.Smooth.IsSmooth);
set(handles.edit_PreFWHM,'String',handles.Smooth.FWHM);

set(handles.cebx_Detrend,'Value',handles.Detrend.IsDetrend);

set(handles.cebx_Cov,'Value',handles.Cov.IsCov);
set(handles.edit_CovDetrend,'String',handles.Cov.IsCovDetrend);
set(handles.cebx_CovFriston,'Value',handles.Cov.IsCovFriston24);
set(handles.cebx_CovWM,'Value',handles.Cov.IsCovWM);
set(handles.cebx_CovCSF,'Value',handles.Cov.IsCovCSF);
set(handles.cebx_CovGlobal,'Value',handles.Cov.IsCovGlobal);
set(handles.cebx_CovAddMean,'Value',handles.Cov.IsAddMeanBack);
set(handles.cebx_CovOther,'Value',handles.Cov.IsCovOther);
set(handles.list_CovOtherList,'String',handles.Cov.CovOtherROI);

set(handles.cebx_Filter,'Value',handles.Filter.IsFilter);
set(handles.edit_FilterLowcut,'String',handles.Filter.LowCut_HighPass);
set(handles.edit_FilterHighcut,'String',handles.Filter.LowPass_HighCut);

set(handles.edit_WinSize,'String',handles.DyPara.WinSize);
set(handles.edit_WinStep,'String',handles.DyPara.WinStep);
switch lower(handles.DyPara.WinType)
    case 'hamming'
        set(handles.pomenu_WinType, 'Value', 1);
    case 'rectwin'
        set(handles.pomenu_WinType, 'Value', 2);
    case 'hann'
        set(handles.pomenu_WinType, 'Value', 3);
end
if strfind(handles.DyMask,'BrainMask_05_61x73x61');
    set(handles.rbtn_DyDefault,'Value',1);
    set(handles.rbtn_DyNoMask,'Value',0);
    set(handles.rbtn_DyUser,'Value',0);
    set(handles.edit_DyUser,'Enable','off');
elseif ~isempty(handles.DyMask)
    set(handles.rbtn_DyDefault,'Value',0);
    set(handles.rbtn_DyNoMask,'Value',0);
    set(handles.rbtn_DyUser,'Value',1);
    set(handles.edit_DyUser,'Enable','on');
    set(handles.edit_DyUser,'String',handles.DyMask);
else isempty(handles.DyMask)
    set(handles.rbtn_DyDefault,'Value',0);
    set(handles.rbtn_DyNoMask,'Value',1);
    set(handles.rbtn_DyUser,'Value',0);
    set(handles.edit_DyUser,'Enable','off');
end
set(handles.cebx_DyDetrend,'Value',handles.DyPara.Detrend);


set(handles.cebx_ALFF,'Value',handles.DyALFF.IsALFF );
set(handles.edit_ALFFLowcut,'String',handles.DyALFF.LowCut_HighPass);
set(handles.edit_ALFFHighcut,'String',handles.DyALFF.LowPass_HighCut);

set(handles.cebx_fALFF,'Value',handles.DyfALFF.IsfALFF );
set(handles.edit_fALFFLowcut,'String',handles.DyfALFF.LowCut_HighPass);
set(handles.edit_fALFFHighcut,'String',handles.DyfALFF.LowPass_HighCut);

set(handles.cebx_ReHo,'Value',handles.DyReHo.IsReHo);
set(handles.rbtn_ReHo7,'Value',0);
set(handles.rbtn_ReHo19,'Value',0);
set(handles.rbtn_ReHo27,'Value',0);
switch handles.DyReHo.Cluster
    case 7
        set(handles.rbtn_ReHo7,'Value',1);
    case 19
        set(handles.rbtn_ReHo19,'Value',1);
    case 27
        set(handles.rbtn_ReHo27,'Value',1);
end

set(handles.cebx_DC,'Value',handles.DyDC.IsDC);
set(handles.edit_DCr,'String',handles.DyDC.rValue);

% set(handles.cebx_GSCorr,'Value',handles.DyGSCorr.IsGSCorr);
% if ~isempty(strfind(handles.DyGSCorr.Mask,'BrainMask_05_61x73x61'));
%     set(handles.rbtn_GSCorrDefault,'Value',1);
%     set(handles.rbtn_GSCorrUser,'Value',0);
%     set(handles.edit_GSCorrUser,'Enable','off');
% elseif ~isempty(handles.DyGSCorr.Mask)
%     set(handles.rbtn_GSCorrDefault,'Value',0)
%     set(handles.rbtn_GSCorrUser,'Value',1);
%     set(handles.edit_GSCorrUser,'Enable','on');
%     set(handles.edit_GSCorrUser,'String',handles.DyGSCorr.Mask);
% end

set(handles.cebx_FC,'Value',handles.DyFC.IsFC);
set(handles.cebx_FCMultiple,'Value',handles.DyFC.IsMultiple);
for i = 1 : length(handles.DyFC.FCROIDef)
    if SphereROI('IsBallArray', handles.DyFC.FCROIDef{i})
        ROI = handles.DyFC.FCROIDef{i};
        FCROIDef{i} = ['ROI Center(mm)=(' num2str(ROI(1)) ', ' num2str(ROI(2)) ', ' num2str(ROI(3))...
            '); Radius=' num2str(sprintf('%.2f',ROI(4))) ' mm.'];
    else
        FCROIDef{i} = handles.DyFC.FCROIDef{i};
    end
end

set(handles.list_FCList,'String',FCROIDef);

% set(handles.cebx_VMHC,'Value',handles.DyVMHC.IsVMHC);
% 
% set(handles.cebx_DyConcor,'Value',handles.DyConcor.IsConcor);
% set(handles.cebx_ConVoxel,'Value',handles.DyConcor.IsVoxelWise);
% set(handles.cebx_ConVolume,'Value',handles.DyConcor.IsVolumeWise);
% set(handles.cebx_ConSmooth,'Value',handles.DyConcor.IsSmooth);
% set(handles.edit_ConFWHM,'String',handles.DyConcor.FWHM);
% set(handles.cebx_ConALFF,'Value',handles.DyConcor.IsALFF);
% set(handles.cebx_ConfALFF,'Value',handles.DyConcor.IsfALFF);
% set(handles.cebx_ConReHo,'Value',handles.DyConcor.IsReHo);
% set(handles.cebx_ConDC,'Value',handles.DyConcor.IsDC);
% set(handles.cebx_ConGSCorr,'Value',handles.DyConcor.IsGSCorr);
% set(handles.cebx_ConVMHC,'Value',handles.DyConcor.IsVMHC);
