function TDAMetrics_Smooth(InDir,OutDir,fwhm)
%-----------------------------------------------------------
%   Written by SUN Jia-Wei 200413.
%   Mail to Authors: jiaweisun0512@163.com
%
    Parameter.FWHM = fwhm;
    infodr_DynamicSmooth(InDir,OutDir,Parameter)
end

function infodr_DynamicSmooth(infodr,outfodr,Parameter)
% Parameter.FWHM
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201502
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com
%   Rivised by Sun-jiawei 20200410
    [ImgType,ImgExt]=infodr_ChekImgTyp(infodr);
    SpmBatch.jobs = init_SpmBatch('SPMdefaultSmooth');
    Parameter=init_SmoothParameter(infodr,ImgType,Parameter);
    SpmBatch = output_SpmBatch4Smooth(SpmBatch,Parameter);
    run_SpmBatch(SpmBatch);
    for i = 1 : length(Parameter.FileList)
        [fPath,fName] = fileparts(Parameter.FileList{i});
        movefile([fPath filesep get_Postfix('Smooth') fName '.nii'],[outfodr filesep fName '_' get_Postfix('Smooth') '.nii']);
    end
end

function Parameter=init_SmoothParameter(infodr_Fun,ImgType,Parameter)
    Parameter.FileList=spread_Fodr4SPM(infodr_Fun,ImgType);
end

function SpmBatch = output_SpmBatch4Smooth(SpmBatch,Parameter)
    SpmBatch.jobs{1,1}.spatial{1,1}.smooth.data = Parameter.FileList; 
    SpmBatch.jobs{1,1}.spatial{1,1}.smooth.fwhm =Parameter.FWHM;
    SpmBatch.jobs{1,1}.spatial{1,1}.smooth.prefix =get_Postfix('Smooth');
end