function varargout=run_BVersionCallback(AOperation,varargin)
% [RunString,VisibleHandleArray,ProcessType]=...
%                          run_BVersionCallback('GUIparaVisible',...
%                                                    'hObject',hObject,...
%                                                    'handles',handles,...
%                                                    'VersionStr',VersionStr,...
%                                                    'CallbackString',CallbackString);
% run_BVersionCallBack('Generate_IOParameter',)
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201507
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com
%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
%   PerAF with add mean back was added by SUN Jia-Wei   20_04_24
%   dicom info was added by LI Zi-qi  210623

CB_value=InitCallbackValueStruct(varargin);
CallbackString=CB_value.CallbackString;


% Pipleline Version RadioButton............
if strcmp(get_GuiTag('BasicVersionRadioBtn'),CallbackString) 
       run_BasicVersionRadioBtn(CB_value);

elseif strcmp(get_GuiTag('AdvancedVersionRadioBtn'),CallbackString)
       run_AdvancedVersionRadioBtn(CB_value);

       
       
% Display Listbox Callback......       
elseif strcmp(get_GuiTag('ParameterDisplayListbox'),CallbackString)
       [VisibleHandleArray,ProcessType,RunString]=run_ParameterDisplayListbox(CB_value);       
         
elseif strcmp(get_GuiTag('PreDefinedParameterPpmenu'),CallbackString)
        VisibleHandleArray=run_PreDefinedParameterPpmenu(CB_value);

     
        
% Push button and Edit Callback...........                
elseif strcmp(get_GuiTag('WorkDirectoryBtn'),CallbackString)
       run_WorkDirectoryBtn(CB_value);  

elseif strcmp(get_GuiTag('DisplayParticipantsBtn'),CallbackString)
       run_DisplayParticipantsBtn(CB_value);

elseif strcmp(get_GuiTag('StartDirectoryEpiEdit'),CallbackString)     
       run_StartDirectoryEpiEdit(CB_value);        

elseif strcmp(get_GuiTag('StartDirectoryT1Edit'),CallbackString)   
       run_StartDirectoryT1Edit(CB_value);   
       
elseif strcmp(get_GuiTag('TREdit'),CallbackString)  %   added by SUN Jia-Wei   20_04_28
elseif strcmp(get_GuiTag('info'),CallbackString)  %  added by LI Zi-qi   210623
       run_Dicominfo(CB_value);
    
elseif strcmp(get_GuiTag('SavePushBtn'),CallbackString)   
       run_SavePushBtn(CB_value);
      
elseif strcmp(get_GuiTag('LoadPushBtn'),CallbackString)
       run_LoadPushBtn(CB_value);
           
      
elseif strcmp(get_GuiTag('RunPushBtn'),CallbackString)
    pipeline_run_pushbutton_callback(CB_value);
     
%Preprocess..................................................................             
elseif strcmp(get_GuiTag('DicomToNiftiChekbox'),CallbackString)...
     ||strcmp(get_RunStr('DicomToNifti'),CallbackString)             
     [RunString,VisibleHandleArray,ProcessType]=run_DicomToNifti(CB_value);

elseif strcmp(get_GuiTag('RemoveFirstTimePointsChekbox'),CallbackString)...
      ||strcmp(get_RunStr('RemoveFirstTimePoints'),CallbackString)              
     [RunString,VisibleHandleArray,ProcessType]=run_RemoveFirstTimePointsChekbox(CB_value);

elseif strcmp(get_GuiTag('SliceTimingChekbox'),CallbackString)...
      ||strcmp(get_RunStr('SliceTiming'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_SliceTimingChekbox(CB_value);

elseif strcmp(get_GuiTag('RealignChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Realign'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_RealignChekbox(CB_value);

elseif strcmp(get_GuiTag('ReorientChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Reorient'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_ReorientChekbox(CB_value);

elseif strcmp(get_GuiTag('NormalizeChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Normalize'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_NormalizeChekbox(CB_value);

elseif strcmp(get_GuiTag('SmoothChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Smooth'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_SmoothChekbox(CB_value);

elseif strcmp(get_GuiTag('DetrendChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Detrend'),CallbackString)
    [RunString,VisibleHandleArray,ProcessType]=run_DetrendChekbox(CB_value);

elseif strcmp(get_GuiTag('FilterChekbox'),CallbackString)...
      ||strcmp(get_RunStr('Filter'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_FilterChekbox(CB_value);

elseif strcmp(get_GuiTag('RegressOutNuisanceChekbox'),CallbackString)...
     ||strcmp(get_RunStr('RegressOutCovariates'),CallbackString);
     [RunString,VisibleHandleArray,ProcessType]=run_RegressOutNuisanceChekbox(CB_value);  
     
     
     
%Mask................................................................................          
elseif strcmp(get_GuiTag('DefaultmaskRadioBtn'),CallbackString)
       run_DefaultmaskRadioBtn(CB_value);
elseif strcmp(get_GuiTag('NoMaskRadioBtn'),CallbackString)
      run_NoMaskRadioBtn(CB_value);
elseif strcmp(get_GuiTag('UserDefinedMaskRadioBtn'),CallbackString)
     run_UserDefinedMaskRadioBtn(CB_value);      
     
     
     
%Post process..................................................................
elseif strcmp(get_GuiTag('AlffRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('Alff'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_AlffRadioBtn(CB_value);

elseif strcmp(get_GuiTag('fALFFRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('fALFF'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_fALFFRadioBtn(CB_value);
     
elseif strcmp(get_GuiTag('WaveletALFFRadioBtn'),CallbackString)...%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
      ||strcmp(get_RunStr('WaveletALFF'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_WaveletALFFRadioBtn(CB_value);

elseif strcmp(get_GuiTag('KccReHoRadioBtn'),CallbackString)....
      ||strcmp(get_RunStr('KccReHo'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_KccReHoRadioBtn(CB_value);

elseif strcmp(get_GuiTag('CoheReHoRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('CoHeReHo'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_CoheReHoRadioBtn(CB_value);

elseif strcmp(get_GuiTag('DegreeCentralityRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('DegreeCentrality'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_DegreeCentralityRadioBtn(CB_value);

elseif strcmp(get_GuiTag('VMHCRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('VMHC'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_VMHCRadioBtn(CB_value);

elseif strcmp(get_GuiTag('PerAFRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('PerAF'),CallbackString)
 [RunString,VisibleHandleArray,ProcessType]=run_PerAFRadioBtn(CB_value);

elseif strcmp(get_GuiTag('GBCRadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('GBC'),CallbackString)
 [RunString,VisibleHandleArray,ProcessType]=run_GBCRadioBtn(CB_value);
 
elseif strcmp(get_GuiTag('FunConnectivityRadioBtn'),CallbackString)...
     ||strcmp(get_RunStr('FunctionalConnectivity'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_FunConnectivityRadioBtn(CB_value);  

elseif strcmp(get_GuiTag('GCARadioBtn'),CallbackString)...
      ||strcmp(get_RunStr('GCA'),CallbackString)
     [RunString,VisibleHandleArray,ProcessType]=run_GCARadioBtn(CB_value);
     
%.....................................................................
else
     error('Tag or RunStr is not exist')
end




if strcmp('GUIparaVisible',AOperation) 
    if 0==exist('RunString','var')
       RunString=''; 
    end     
    
    if 0==exist('VisibleHandleArray','var')
       VisibleHandleArray=''; 
    end   

    if 0==exist('ProcessType','var')
       ProcessType=''; 
    end
    varargout{1}=RunString;
    varargout{2}=VisibleHandleArray;
    varargout{3}=ProcessType;
end    
    
end


function CB_value=InitCallbackValueStruct(vararginCell)

for i=1:2:length(vararginCell)
    AOperationName=vararginCell{i};
    AOperationValue=vararginCell{i+1};
    switch upper(AOperationName)
        case upper('hObject')
            CB_value.hObject=AOperationValue;
        case upper('handles')
            CB_value.handles=AOperationValue;
        case upper('VersionStr')
            CB_value.VersionStr=AOperationValue;
        case upper('CallbackString')
            CB_value.CallbackString=AOperationValue;
        case upper('IOListIn')
            CB_value.IOListIn=AOperationValue;
        case upper('InputParameter')
            CB_value.InputParameter=AOperationValue;
        case upper('AnalysisDir')
            CB_value.AnalysisDir=AOperationValue;            
    end
end
end





function run_BasicVersionRadioBtn(CB_value)
    hObject=CB_value.hObject;
    handles=CB_value.handles;
    RadioBtnSet(handles.VersionRadioBtn.Array,hObject);
end

function run_AdvancedVersionRadioBtn(CB_value)
   hObject=CB_value.hObject;
   handles=CB_value.handles;
   RadioBtnSet(handles.VersionRadioBtn.Array,hObject);
   close(handles.MainFigure);
   repipla;
end


function [VisibleHandleArray,ProcessType,RunString]=run_ParameterDisplayListbox(CB_value)
hObject=CB_value.hObject;
handles=CB_value.handles;
VersionStr=CB_value.VersionStr;

 Listindex=get(hObject,'value');
 Liststr=get(hObject,'string');
 CurrentStr=deblank(Liststr(Listindex,:));
 if ~isempty(CurrentStr)
    [RunString,VisibleHandleArray,ProcessType]=...
                 run_BVersionCallback('GUIparaVisible',...
                                      'hObject',hObject,...
                                      'handles',handles,...
                                      'VersionStr',VersionStr,...
                                       'CallbackString',CurrentStr);  
 else
     VisibleHandleArray='';
     ProcessType='';   
 end
 RunString='';
end


function run_SaveDisplayListbox(CB_value)
    VersionStr=CB_value.VersionStr;
    hObject=CB_value.hObject;
    handles=CB_value.handles;
    restgui_misc('run_SaveDisplayListbox',VersionStr,hObject,handles); 
end


function VisibleHandleArray=run_PreDefinedParameterPpmenu(CB_value)
hObject=CB_value.hObject;
handles=CB_value.handles;

Ppmenustr=get(hObject,'string');
Ppmenuindex=get(hObject,'value');
[OperationList,InputParameter,GuiParameter]=...
                                  repipl_PreDefinedParameter(deblank(Ppmenustr(Ppmenuindex,:)));
UpdateGUI_BasicVersion(OperationList,handles,InputParameter,GuiParameter);
set(handles.UIhandles.DefaultmaskRadioBtn.handle,'value',1);

VisibleHandleArray='';

end


function run_WorkDirectoryBtn(CB_value)
    handles=CB_value.handles;
    handles.UIvalue.WorkDirectory.value=uigetdir(pwd);
    if 0~=handles.UIvalue.WorkDirectory.value
        cd(handles.UIvalue.WorkDirectory.value);
        set(handles.UIhandles.WorkDirectoryEdit.handle,...
            'string',handles.UIvalue.WorkDirectory.value);
    end
end

function run_Dicominfo(CB_value)   % added by LI Zi-qi  210623
   handles=CB_value.handles;
   hObject=CB_value.hObject;
   
   project_dir_pth=get(handles.UIhandles.WorkDirectoryEdit.handle,'string');
   EPI_dir_name=get(handles.UIhandles.StartDirectoryEpiEdit.handle,'string');

   results=init_results_xlsx();
   
   if ~isempty(EPI_dir_name)
       crt_pth=[project_dir_pth filesep EPI_dir_name];
       subject_list=dir_NameList(crt_pth);
       tmp_subject_pth=[crt_pth filesep subject_list{1}];
       filelist=dir_NameList(tmp_subject_pth);
       crt_file_pth=[tmp_subject_pth filesep filelist{1}];
       [~,~,ext]=fileparts(crt_file_pth);
       if ~strcmp(ext,'.nii') && ~strcmp(ext,'.img') && ~strcmp(ext,'.hdr') &&~strcmp(ext,'.json')
           crt_info=dicominfo(crt_file_pth);
           dicom_list={'RepetitionTime','PatientID','ProtocolName','Manufacturer','SliceThickness','EchoTime','FlipAngle'};
           info=get_isfield(crt_info,dicom_list);
           textfile={'Dicom Info: '
                         ['1. TR: '                    num2str(info.TR) 'ms'];...
                         ['2. PatientsID: '        info.PatientID];...
                         ['3. SubjectsName: ' info.PatientName];...
                         ['4. ProtocalName: '  info.ProtocolName];...
                         ['5. Manufacturer: '    info.Manufacturer];...
                         ['6. SliceThickness: ' num2str(info.SliceThickness)];...
                         ['7. EchoTime: '         num2str(info.EchoTime)];...
                         ['8. FlipAngle: '          num2str(info.FlipAngle)]};
             msgbox(textfile,'Dicominfo');
             excel_file=get_subject_dcminfo_xlsx(subject_list,crt_pth,results,dicom_list);
             xlswrite([project_dir_pth filesep 'REST_DicomInfo.xlsx'],excel_file,'AllSubject','1');
             msgbox(['DicomInfo is save in: ' project_dir_pth filesep 'REST_DicomInfo.xlsx']);
        else
               warndlg('Data must be dicom format, no dicom in subject dir !');
        end
   else
       warndlg('Have no EPI name, Please input the EPI directory name !');
   end
end

function results=get_isfield(crt_info,dicom_list)
    if isfield(crt_info.PatientName,'FamilyName')
       results.PatientName=crt_info.PatientName.FamilyName;
   else
       results.PatientName=crt_info.PatientName;
   end
    crt_field=isfield(crt_info,dicom_list);
    for i=1:length(crt_field)
       switch i
           case 1
               results.TR=get_name(crt_field(i),crt_info,'RepetitionTime');
           case 2
               results.PatientID=get_name(crt_field(i),crt_info,'PatientID');
           case 3
               results.ProtocolName=get_name(crt_field(i),crt_info,'ProtocolName');
           case 4
               results.Manufacturer=get_name(crt_field(i),crt_info,'Manufacturer');
           case 5
               results.SliceThickness=get_name(crt_field(i),crt_info,'SliceThickness');
           case 6
               results.EchoTime=get_name(crt_field(i),crt_info,'EchoTime');
           case 7
               results.FlipAngle=get_name(crt_field(i),crt_info,'FlipAngle');
       end
    end
end

function results=get_name(value,crt_info,fieldname)
if value
   results=crt_info.(fieldname);
else
   results='none';
end
end

function results=get_subject_dcminfo_xlsx(subject_list,crt_pth,results,dicom_list)
for subject_idx=1:length(subject_list)
     crt_sub_pth=[crt_pth filesep subject_list{subject_idx}];
     dicomfiles=dir_NameList(crt_sub_pth);
     dcm_pth=[crt_sub_pth filesep dicomfiles{1}];
     crt_info=dicominfo(dcm_pth);
     info=get_isfield(crt_info,dicom_list);
     results{subject_idx+1,2}=[num2str(info.TR) 'ms'];
     results{subject_idx+1,3}=info.PatientID;
     results{subject_idx+1,4}=info.PatientName;
     results{subject_idx+1,5}=info.ProtocolName;
     results{subject_idx+1,6}=info.Manufacturer;
     results{subject_idx+1,7}=num2str(info.SliceThickness);
     results{subject_idx+1,8}=num2str(info.EchoTime);
     results{subject_idx+1,9}=num2str(info.FlipAngle);
     results{subject_idx+1,1}=subject_list{subject_idx};
 end
end

function results=init_results_xlsx()
   results{1,2}='TR';
   results{1,3}='PatientsID';
   results{1,4}='SubjectsName';
   results{1,5}='ProtocalName';
   results{1,6}='Manufacturer';
   results{1,7}='SliceThickness';
   results{1,8}='EchoTime';
   results{1,9}='FlipAngle';
end

function run_DisplayParticipantsBtn(CB_value)
   handles=CB_value.handles;
   hObject=CB_value.hObject;
   
   WorkDirectory=get(handles.UIhandles.WorkDirectoryEdit.handle,'string');
   StartFunImg=get(handles.UIhandles.StartDirectoryEpiEdit.handle,'string');
   StartT1Img=get(handles.UIhandles.StartDirectoryT1Edit.handle,'string');
   if isdir([WorkDirectory filesep StartFunImg])
          SubfodrList=dir_NameList([WorkDirectory filesep StartFunImg]);
   elseif isdir([WorkDirectory filesep StartT1Img])
          SubfodrList=dir_NameList([WorkDirectory filesep StartT1Img]);
   else
       msgbox('Folder is not exist!');
       return;
       
   end
   ListboxStr=brief_misc('CellArray2Listboxstr',SubfodrList);
   set(handles.hPara.ParticipantsListInput.DisplayListbox,...
       'string',ListboxStr)

   VisibleHandleArray=handles.hParaArray.ParticipantsList;
    updata_GuiVisible(hObject,VisibleHandleArray,handles.hParaAll); 
end


function run_StartDirectoryEpiEdit(CB_value)
  handles=CB_value.handles;

   WorkDirectory=get(handles.UIhandles.WorkDirectoryEdit.handle,'string');
   StartFunImg=get(handles.UIhandles.StartDirectoryEpiEdit.handle,'string');
   
   AllHandleArray=handles.hParaAll;
   for i=1:length(AllHandleArray)
          set(AllHandleArray(i), 'Visible', 'off');
   end
      
   if isdir([WorkDirectory filesep StartFunImg])...
      &&~isempty(StartFunImg)     
      tmpSubfodrList=dir_NameList([WorkDirectory filesep StartFunImg]);
      idx=1;
      for i=1:length(tmpSubfodrList)                                            % added by LI Zi-qi  210723
          if isempty(strfind(tmpSubfodrList{i}(1:2),'._')) && isempty(strfind(tmpSubfodrList{i}(1),'.')) && isempty(strfind(tmpSubfodrList{i}(1),'_'))
              SubfodrList{idx}=tmpSubfodrList{i};
              idx=idx+1;
          end
      end
      ListboxStr=brief_misc('CellArray2Listboxstr',SubfodrList);
      set(handles.hPara.ParticipantsListInput.DisplayListbox,...
          'string',ListboxStr)
      VisibleHandleArray=handles.hParaArray.ParticipantsList;
      
     
      for i=1:length(VisibleHandleArray)
          set(VisibleHandleArray(i), 'Visible', 'on');
      end       
   end

end

function run_StartDirectoryT1Edit(CB_value)
   handles=CB_value.handles;

   WorkDirectory=get(handles.UIhandles.WorkDirectoryEdit.handle,'string');
   StartT1Img=get(handles.UIhandles.StartDirectoryT1Edit.handle,'string');
   
   AllHandleArray=handles.hParaAll;
   for i=1:length(AllHandleArray)
          set(AllHandleArray(i), 'Visible', 'off');
   end
      
   if isdir([WorkDirectory filesep StartT1Img])...
      &&~isempty(StartT1Img)     
      SubfodrList=dir_NameList([WorkDirectory filesep StartT1Img]);
      ListboxStr=brief_misc('CellArray2Listboxstr',SubfodrList);
      set(handles.hPara.ParticipantsListInput.DisplayListbox,...
          'string',ListboxStr)
      VisibleHandleArray=handles.hParaArray.ParticipantsList;
      
     
      

      for i=1:length(VisibleHandleArray)
          set(VisibleHandleArray(i), 'Visible', 'on');
      end
   end
end


function run_SavePushBtn(CB_value)
    VersionStr=CB_value.VersionStr;
    handles=CB_value.handles;
    restgui_misc('Run_SaveBtn',VersionStr,handles);
end


function  run_LoadPushBtn(CB_value)
    handles=CB_value.handles;
    restgui_misc('Run_LoadBtn',handles);       
end

function [RunString,VisibleHandleArray,ProcessType]=run_DicomToNifti(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('DicomToNifti');
       VisibleHandleArray=handles.hParaArray.DicomToNifti;
       ProcessType='Preprocess';

end

 function [RunString,VisibleHandleArray,ProcessType]=run_RemoveFirstTimePointsChekbox(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('RemoveFirstTimePoints');
       VisibleHandleArray=handles.hParaArray.RemoveTimePoints;
       ProcessType='Preprocess';

 end
 
    function [RunString,VisibleHandleArray,ProcessType]=run_SliceTimingChekbox(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('SliceTiming');
       VisibleHandleArray=handles.hParaArray.SliceTiming;       
       ProcessType='Preprocess';
    end

    function [RunString,VisibleHandleArray,ProcessType]=run_RealignChekbox(CB_value)
       RunString=get_RunStr('Realign');
       VisibleHandleArray='';
       ProcessType='Preprocess';
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_ReorientChekbox(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('Reorient');    
        VisibleHandleArray=handles.hParaArray.Reorient;    
        ProcessType='Preprocess';
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_NormalizeChekbox(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('Normalize');
        VisibleHandleArray=handles.hParaArray.NormalizePara;    
        ProcessType='Preprocess';
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_SmoothChekbox(CB_value)
        handles=CB_value.handles;
        hObject=CB_value.hObject;
        RunString=get_RunStr('Smooth');    
        VisibleHandleArray=handles.hParaArray.Smooth;    
        ProcessType='Preprocess';
        restgui_misc('check_if_smooth_after',hObject);
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_DetrendChekbox(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('Detrend');
        VisibleHandleArray='';
        ProcessType='Preprocess';
        
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_FilterChekbox(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('Filter');
        VisibleHandleArray=handles.hParaArray.Filter;    
        ProcessType='Preprocess';

    end
    
    
    
    function [RunString,VisibleHandleArray,ProcessType]=run_RegressOutNuisanceChekbox(CB_value)
        handles=CB_value.handles;
        VisibleHandleArray=handles.hParaArray.RegressOutNuisance;    
        RunString=get_RunStr('RegressOutCovariates');
        ProcessType='Preprocess';
    end
    
    
    
    
    
    
    
    
    function [RunString,VisibleHandleArray]=run_DefaultmaskRadioBtn(CB_value)
       hObject=CB_value.hObject;
       handles=CB_value.handles;
       VisibleHandleArray='';
       RunString='';
       RadioBtnSet(handles.hParaArray.ChooseMask,hObject);
       AllHandleArray=handles.hParaAll;        
       updata_GuiVisible(hObject,'',AllHandleArray);
    end
    
    function [RunString,VisibleHandleArray]=run_NoMaskRadioBtn(CB_value)
        hObject=CB_value.hObject;
        handles=CB_value.handles;
        VisibleHandleArray='';
        RunString='';
        RadioBtnSet(handles.hParaArray.ChooseMask,hObject);
        AllHandleArray=handles.hParaAll;
        updata_GuiVisible(hObject,'',AllHandleArray);
    end
    
    function [RunString,VisibleHandleArray]=run_UserDefinedMaskRadioBtn(CB_value)
        hObject=CB_value.hObject;
        handles=CB_value.handles;
        RunString='';
        [msk_name,msk_pth]= uigetfile({'*.img;*.nii'},pwd);  %   getmsk 200721
        RadioBtnSet(handles.hParaArray.ChooseMask,hObject);
        AllHandleArray=handles.hParaAll;
        VisibleHandleArray=handles.hParaArray.Usermask;
        set(handles.hPara.UserMask.Edit,'string',[msk_pth msk_name]); %   getmsk 200721
        updata_GuiVisible(hObject,VisibleHandleArray,AllHandleArray);
    end
    
    
    
    
    
    
    
    
    function [RunString,VisibleHandleArray,ProcessType]=run_AlffRadioBtn(CB_value)    
        handles=CB_value.handles;
        RunString=get_RunStr('Alff');
        ProcessType='Postprocess';
        VisibleHandleArray=handles.hParaArray.ALFF;    
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_fALFFRadioBtn(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('fALFF');
        ProcessType='Postprocess';    
        VisibleHandleArray=handles.hParaArray.fALFF;    
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_WaveletALFFRadioBtn(CB_value)%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
        handles=CB_value.handles;
        RunString=get_RunStr('WaveletALFF');
        ProcessType='Postprocess';    
        VisibleHandleArray=handles.hParaArray.WaveletALFF;    
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_KccReHoRadioBtn(CB_value)
        hObject=CB_value.hObject;
        handles=CB_value.handles;
        RunString=get_RunStr('KccReHo');
        ProcessType='Postprocess';    
        VisibleHandleArray=handles.hParaArray.KccReHo; 
        restgui_misc('check_if_smooth_after',hObject);
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_CoheReHoRadioBtn(CB_value)
        handles=CB_value.handles;
        hObject=CB_value.hObject;
        RunString=get_RunStr('CoHeReHo');
        ProcessType='Postprocess';
        VisibleHandleArray=handles.hParaArray.CoheReHo;
        restgui_misc('check_if_smooth_after',hObject);
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_DegreeCentralityRadioBtn(CB_value)
        handles=CB_value.handles;
        hObject=CB_value.hObject;
        RunString=get_RunStr('DegreeCentrality');
        ProcessType='Postprocess';    
        VisibleHandleArray=handles.hParaArray.DegreeCentrality;
        restgui_misc('check_if_smooth_after',hObject);
    end
    
    
    function [RunString,VisibleHandleArray,ProcessType]=run_VMHCRadioBtn(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('VMHC');
        ProcessType='Postprocess';
        VisibleHandleArray='';
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_PerAFRadioBtn(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('PerAF');
       ProcessType='Postprocess';
       VisibleHandleArray='';
       if get(handles.UIhandles.PerAFRadioBtn.handle,'Value') == 1 
           get_citation('peraf');%add peraf citation   20_06_27
       end
       restgui_misc('check_if_addmeanback_withperaf');% PerAF with add mean back was added by SUN Jia-Wei   20_04_24
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_GBCRadioBtn(CB_value)
        handles=CB_value.handles;
        RunString=get_RunStr('GBC');
        ProcessType='Postprocess';
        VisibleHandleArray='';
    end
    
    function [RunString,VisibleHandleArray,ProcessType]=run_FunConnectivityRadioBtn(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('FunctionalConnectivity');
       ProcessType='Postprocess';
       VisibleHandleArray=handles.hParaArray.FunConnectivity;    
    end


    function [RunString,VisibleHandleArray,ProcessType]=run_GCARadioBtn(CB_value)
       handles=CB_value.handles;
       RunString=get_RunStr('GCA');
       ProcessType='Postprocess';
       VisibleHandleArray=handles.hParaArray.GCA_AwaysVisible; 
    end

