function handles=InitGUI_AdvancedVersion(handles,UserP)
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201412
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com



set(handles.MainFigure,'unit','pixels','position',[520 145 1000 670]);
set(handles.MainFigure,'Name','RESTplus');
movegui(handles.MainFigure,'center');
set(handles.UIhandles.BasicVersionRadioBtn.handle,'value',0);
set(handles.UIhandles.AdvancedVersionRadioBtn.handle,'value',1);


handles=InitGUI_UIpanel(handles,UserP);
handles=init_other_module_ui(handles,UserP);
handles=init_process_ui(handles,UserP);
handles=InitGUI_SetMask(handles,UserP);
handles=init_parameter_ui(handles,UserP);


end



function handles=InitGUI_UIpanel(handles,UserP)
    
handles.ParameterUIpanel.handle= ...
                              uipanel(handles.MainFigure,...
                                      'title','Parameter',...
                                      'fontname','fixedwidth',...
                                      'fontweight','bold',...
                                      'fontunits','normalized',...
                                      'fontsize',0.065,...
                                      'backgroundcolor',get(gcf,'color'),...
                                      'position',[UserP.UIpanel.X,UserP.UIpanel.Y-0.56,0.57,0.35]); 
                                                                     
end


function handles=init_other_module_ui(handles,UserP)

Preprocess_UIlist={{'module_name',{'WorkDirectoryText','WorkDirectoryEdit'},...
                      'style','text_edit',...
                      'string',{'Work directory',pwd},...
                      'tag',{get_GuiTag('WorkDirectoryText'),get_GuiTag('WorkDirectoryEdit')},...
                      'pos_xy_gap_width',[UserP.flexible.work_directory.x,...
                                          UserP.flexible.work_directory.y-0.0015,0.002,0.385],...
                     },...
                     {'module_name','WorkDirectoryBtn',...
                      'style','pushbutton',...
                      'string','...',...
                      'tag',get_GuiTag('WorkDirectoryBtn'),...
                      'pos_xy_width_height',[UserP.flexible.work_directory.x+0.39,...
                                             UserP.flexible.work_directory.y-0.001,...
                                             0.05,0.04],...
                     },...
                     {'module_name',{'TRText','TREdit'},...
                      'style','text_edit',...
                      'string',{'TR(sec)','2'},...
                      'tag',{get_GuiTag('TRText'),get_GuiTag('TREdit')},...
                      'pos_xy_gap_width',[UserP.flexible.tr.x,...
                                          UserP.flexible.tr.y,0.001,0.15],...
                     },...
                     {'module_name',{'ParameterDisplayListboxTip','ParameterDisplayListbox'},...
                    'visible','on',...
                    'style','text_listbox',...
                    'tag',{'tagdefault',get_GuiTag('ParameterDisplayListbox')},...
                    'fontsize',0.05,...
                    'string',{'Process list',''},...
                    'pos_xy_gap_width_height',[UserP.flexible.parameter_listbox.x,...
                                               UserP.flexible.parameter_listbox.y+0.07,...
                                               0.0001,...
                                               0.35,0.77]},...
                      {'module_name','LoadBtn',...
                      'style','pushbutton',...
                      'string','load',...
                      'tag',get_GuiTag('LoadPushBtn'),...
                      'pos_xy_width_height',[UserP.flexible.pushbtn.x,...
                                             UserP.flexible.pushbtn.y,...
                                             0.08,0.06],...
                     },...   
                     {'module_name','SaveBtn',...
                      'style','pushbutton',...
                      'string','save',...
                      'tag',get_GuiTag('SavePushBtn'),...
                      'pos_xy_width_height',[UserP.flexible.pushbtn.x+0.12,...
                                             UserP.flexible.pushbtn.y,...
                                             0.08,0.06],...
                     },...   
                      {'module_name','RunBtn',...
                      'style','pushbutton',...
                      'string','Run',...
                      'tag',get_GuiTag('RunPushBtn'),...
                      'pos_xy_width_height',[UserP.flexible.pushbtn.x+0.12*2,...
                                             UserP.flexible.pushbtn.y,...
                                             0.08,0.06],...
                     },...  
                     {'module_name','parallel_checkbox',...
                      'style','checkbox',...
                      'string','Parallel processing ',...
                      'tag','tag_parallel_checkbox',...
                      'pos_xy',[UserP.flexible.pushbtn.x,...
                                UserP.flexible.pushbtn.y+0.075],...
                     },...
                     {'module_name',{'parallel_text','parallel_edit'},...
                      'style','text_edit',...
                      'string',{'Workers',''},...
                      'tag',{'tag_parallel_text','tag_parallel_edit'},...
                      'enable','off',...
                      'pos_xy_gap_width',[UserP.flexible.pushbtn.x+0.2,...
                                          UserP.flexible.pushbtn.y+0.07,0.01,0.13],...
                     },...
                     };
                 
 if_assign_style='';                               
 handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,if_assign_style);  
                                    

%                       {'module_name','StopBtn',...
%                       'style','pushbutton',...
%                       'string','Stop',...
%                       'tag',get_GuiTag('StopPushBtn'),...
%                       'pos_xy_width_height',[UserP.flexible.pushbtn.x+0.09*3,...
%                                              UserP.flexible.pushbtn.y,...
%                                              0.08,0.06],...
%                      },...
 
end


function handles=init_process_ui(handles,UserP)
Preprocess_UIlist={{'module_name','EpiDicomtoNiftiChekbox',...
                    'tag',get_GuiTag('EpiDicomtoNiftiChekbox'),...
                    'string','EPI DICOM to NIFTI',...
                    'pos_xy',[UserP.flexible.propcess.line1.column1.x,...
                              UserP.flexible.propcess.line1.column1.y]},...
                    ...
                    {'module_name','T1DicomToNiftiChekbox',...
                    'tag',get_GuiTag('T1DicomToNiftiChekbox'),...
                    'string','T1 DICOM to NIFTI',...
                    'pos_xy',[UserP.flexible.propcess.line1.column2.x,...
                              UserP.flexible.propcess.line1.column2.y]},...
                    ...
                    {'module_name','RemoveFirstTimePointsChekbox',...
                    'tag',get_GuiTag('RemoveFirstTimePointsChekbox'),...
                    'string','Remove first n time points',...
                    'pos_xy',[UserP.flexible.propcess.line2.column1.x,...
                              UserP.flexible.propcess.line2.column1.y]},...
                    ...
                    {'module_name','SliceTimingChekbox',...
                    'tag',get_GuiTag('SliceTimingChekbox'),...
                    'string','Slice timing',...
                    'pos_xy',[UserP.flexible.propcess.line2.column2.x,...
                              UserP.flexible.propcess.line2.column2.y]},...
                    ...
                    {'module_name','RealignChekbox',...
                    'tag',get_GuiTag('RealignChekbox'),...
                    'string','Realign',...
                    'pos_xy',[UserP.flexible.propcess.line3.column1.x,...
                              UserP.flexible.propcess.line3.column1.y]},...
                    ...
                    {'module_name','ReorientFunBeforeCoregChekbox',...
                    'tag',get_GuiTag('ReorientFunBeforeCoregChekbox'),...
                    'string','Reorient Fun before coregister',...
                    'pos_xy',[UserP.flexible.propcess.line3.column2.x,...
                              UserP.flexible.propcess.line3.column2.y]},...
                    ...
                    {'module_name','ReorientT1BeforeCoregChekbox',...
                    'tag',get_GuiTag('ReorientT1BeforeCoregChekbox'),...
                    'string','Reorient T1 before coregister',...
                    'pos_xy',[UserP.flexible.propcess.line4.column1.x,...
                              UserP.flexible.propcess.line4.column1.y]},...
                    ...
                    {'module_name','T1CoregisterFunChekbox',...
                    'tag',get_GuiTag('T1CoregisterFunChekbox'),...
                    'string','T1 coregister to Fun',...
                    'pos_xy',[UserP.flexible.propcess.line4.column2.x,...
                              UserP.flexible.propcess.line4.column2.y]},...
                    ...
                    {'module_name','ReorientT1AfterCoregChekbox',...
                    'tag',get_GuiTag('ReorientT1AfterCoregChekbox'),...
                    'string','Reorient T1 after coregister',...
                    'pos_xy',[UserP.flexible.propcess.line5.column1.x,...
                              UserP.flexible.propcess.line5.column1.y]},...
                    ...
                    {'module_name','T1SegmentChekbox',...
                    'tag',get_GuiTag('T1SegmentChekbox'),...
                    'string','T1 segment',...
                    'pos_xy',[UserP.flexible.propcess.line5.column2.x,...
                              UserP.flexible.propcess.line5.column2.y]},...
                    ...
                    {'module_name','NormalizeEpiChekbox',...
                    'tag',get_GuiTag('NormalizeEpiChekbox'),...
                    'string','Normalize by using EPI template',...
                    'pos_xy',[UserP.flexible.propcess.line6.column1.x,...
                              UserP.flexible.propcess.line6.column1.y]},...
                    ...
                    {'module_name','NormalizeSegChekbox',...
                    'tag',get_GuiTag('NormalizeSegChekbox'),...
                    'string','Normalize by using T1 image unified segmentation',...
                    'pos_xy',[UserP.flexible.propcess.line7.column1.x,...
                              UserP.flexible.propcess.line7.column1.y]},...
                    ...
                    {'module_name','Normalize_T1NewSeg_dartel_Chekbox',...
                    'tag',get_GuiTag('Normalize_T1NewSeg_dartel_Chekbox'),...
                    'string','Normalize by DARTEL using T1 image new segment',...
                    'pos_xy',[UserP.flexible.propcess.line8.column1.x,...
                              UserP.flexible.propcess.line8.column1.y]},...
                    ...
                    {'module_name','Normalize_SymT1seg_Chekbox',...
                    'tag',get_GuiTag('NormalizeSymT1segChekbox'),...
                    'string','Normalize to symmetric T1 template (unified segmentation)',...
                    'visible','off',...
                    'pos_xy',[UserP.flexible.propcess.line9.column1.x,...
                              UserP.flexible.propcess.line9.column1.y]},...
                    ...
                    {'module_name','SmoothChekbox',...
                    'tag',get_GuiTag('SmoothChekbox'),...
                    'string','Smooth',...
                    'pos_xy',[UserP.flexible.propcess.line9.column1.x,...
                              UserP.flexible.propcess.line9.column1.y]},...
                    ...
                    {'module_name','DetrendChekbox',...
                    'tag',get_GuiTag('DetrendChekbox'),...
                    'string','Detrend',...
                    'pos_xy',[UserP.flexible.propcess.line9.column2.x,...
                              UserP.flexible.propcess.line9.column2.y]},...
                    ...
                    {'module_name','FilterChekbox',...
                    'tag',get_GuiTag('FilterChekbox'),...
                    'string','Filter',...
                    'pos_xy',[UserP.flexible.propcess.line10.column1.x,...
                              UserP.flexible.propcess.line10.column1.y]},...
                    ...
                    {'module_name','RegressOutCovariatesChekbox',...
                    'tag',get_GuiTag('RegressOutNuisanceChekbox'),...
                    'string','Nuisance covariates regression',...
                    'pos_xy',[UserP.flexible.propcess.line10.column2.x,...
                              UserP.flexible.propcess.line10.column2.y]},...
                    ...
                    {'module_name','AlffChekbox',...
                    'tag',get_GuiTag('AlffRadioBtn'),...
                    'string','ALFF',...
                    'pos_xy',[UserP.flexible.propcess.line14.column1.x,...
                              UserP.flexible.propcess.line14.column1.y]},...
                    ...
                    {'module_name','fALFFChekbox',...
                    'tag',get_GuiTag('fALFFRadioBtn'),...
                    'string','fALFF',...
                    'pos_xy',[UserP.flexible.propcess.line14.column1.x+0.15,...
                              UserP.flexible.propcess.line14.column1.y]},...
                    ...
                    {'module_name','PerAFChekbox',...
                    'tag',get_GuiTag('PerAFRadioBtn'),...
                    'string','PerAF',...
                    'pos_xy',[UserP.flexible.propcess.line14.column1.x+0.3,...
                              UserP.flexible.propcess.line14.column1.y]},...
                    ...
                    {'module_name','GBCChekbox',...
                    'tag',get_GuiTag('GBCRadioBtn'),...
                    'string','GBC',...
                    'pos_xy',[UserP.flexible.propcess.line14.column1.x+0.45,...
                              UserP.flexible.propcess.line14.column1.y]},...
                    ...
                    {'module_name','KccReHoChekbox',...
                    'tag',get_GuiTag('KccReHoRadioBtn'),...
                    'string','KCC-ReHo',...
                    'pos_xy',[UserP.flexible.propcess.line15.column1.x,...
                              UserP.flexible.propcess.line15.column1.y]},...
                    ...
                    {'module_name','CoheReHoChekbox',...
                    'tag',get_GuiTag('CoheReHoRadioBtn'),...
                    'string','Cohe-ReHo',...
                    'pos_xy',[UserP.flexible.propcess.line15.column1.x+0.15,...
                              UserP.flexible.propcess.line15.column1.y]},...
                    ...
                    {'module_name','DegreeCentralityChekbox',...
                    'tag',get_GuiTag('DegreeCentralityRadioBtn'),...
                    'string','Degree centrality',...
                    'pos_xy',[UserP.flexible.propcess.line16.column1.x,...
                              UserP.flexible.propcess.line16.column1.y]},...
                    ...
                    {'module_name','FunConnectivityChekbox',...
                    'tag',get_GuiTag('FunConnectivityRadioBtn'),...
                    'string','Functional connectivity',...
                    'pos_xy',[UserP.flexible.propcess.line16.column1.x+0.17,...
                              UserP.flexible.propcess.line16.column1.y]}...
                    ...
                    {'module_name','GCAChekbox',...
                    'tag',get_GuiTag('GCARadioBtn'),...
                    'string','GCA',...
                    'pos_xy',[UserP.flexible.propcess.line16.column1.x+0.38,...
                              UserP.flexible.propcess.line16.column1.y]}...
%                     {'module_name','VMHCChekbox',...
%                     'tag',get_GuiTag('VMHCRadioBtn'),...
%                     'string','VMHC',...
%                     'pos_xy',[UserP.flexible.propcess.line16.column1.x+0.26,...
%                               UserP.flexible.propcess.line16.column1.y]},...
                    };
handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,'checkbox'); 
                                     
                                     
end

function handles=InitGUI_SetMask(handles,UserP)

Preprocess_UIlist={{'module_name','DefaultmaskRadioBtn',...
                    'tag',get_GuiTag('DefaultmaskRadioBtn'),...
                    'string','Default mask',...
                    'value',1,...
                    'pos_xy',[UserP.flexible.propcess.line13.column1.x,...
                              UserP.flexible.propcess.line13.column1.y]},...
                    ...
                    {'module_name','NoMaskRadioBtn',...
                    'tag',get_GuiTag('NoMaskRadioBtn'),...
                    'string','No mask',...
                    'pos_xy',[UserP.flexible.propcess.line13.column1.x+0.15,...
                              UserP.flexible.propcess.line13.column1.y]},...
                    ...
                    {'module_name','UserDefinedMaskRadioBtn',...
                    'tag',get_GuiTag('UserDefinedMaskRadioBtn'),...
                    'string','User defined mask',...
                    'pos_xy',[UserP.flexible.propcess.line13.column1.x+0.26,...
                              UserP.flexible.propcess.line13.column1.y]},...
                    ...
                    };

handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,'radiobutton'); 
                   
                    
 
                                     
                                       
end


function handles=init_parameter_ui(handles,UserP)
Preprocess_UIlist = {{'module_name','DisplayParticipants',...
                      'module_para',{'ParticipantsText','ParticipantsListbox'},...
                      'visible','off',...
                      'style','text_listbox',...
                      'tag',{'tagdefault',get_GuiTag('ParameterDisplayListbox')},...
                      'string',{'Participants',''},...
                      'pos_xy_gap_width_height',[UserP.flexible.parameter.line5.column1.x+0.1,...
                                                 UserP.flexible.parameter.line5.column1.y,...
                                                 0.0001,...
                                                 0.3,0.2]},...
                     {'module_name','EpiDicomToNifti',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input functional DICOM folder name','EPI_DICOM_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','EpiDicomToNifti',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output functional NIFTI folder name','EPI_NIFTI_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1DicomToNifti',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input T1 DICOM folder name','T1_DICOM_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1DicomToNifti',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output T1 DICOM folder name','T1_NIFTI_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','RemoveTimePoints',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input EPI folder name','Input_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','RemoveTimePoints',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output EPI folder name','Output_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','RemoveTimePoints',...
                     'module_para',{'AmountText','AmountEdit'},...
                     'style','text_edit',...
                     'string',{'Remove time points number','10'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input EPI folder name','Input_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output EPI folder name','Output_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'SliceNumberText','SliceNumberEdit'},...
                     'style','text_edit',...
                     'string',{'Slice number','33'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'SliceOrderText','SliceOrderEdit'},...
                     'style','text_edit',...
                     'string',{'Slice order',num2str(eval('[1:2:33 2:2:32]'))},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line4.column1.x,...
                                         UserP.flexible.parameter.line4.column1.y,0.001,0.55],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'ReferenceSliceText','ReferenceSliceEdit'},...
                     'style','text_edit',...
                     'string',{'Reference slice','33'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Realign',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input EPI folder name','Input_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Realign',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output EPI folder name','Output_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Realign',...
                     'module_para',{'OutdirRealignParaText','OutdirRealignParaEdit'},...
                     'style','text_edit',...
                     'string',{'Output realign parameter folder name',get_Postfix('RealignParameter')},...   
                     'visible','off',...
                     'enable','on',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','ReorientFunBeforeCoreg',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input realign parameter folder name',get_Postfix('RealignParameter')},...   
                     'visible','off',...
                     'enable','on',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeEpi',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for normalization','Input_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeEpi',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after normalization','Output_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeEpi',...
                     'module_para',{'IndirRealignParaText','IndirRealignParaEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of mean file',get_Postfix('RealignParameter')},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeEpi',...
                     'module_para',{'BoundingBoxText','BoundingBoxEdit'},...
                     'style','text_edit',...
                     'string',{'Bounding box','[-90,-126,-72;90,90,108]'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line4.column1.x,...
                                         UserP.flexible.parameter.line4.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeEpi',...
                     'module_para',{'VoxSizeText','VoxSizeEdit'},...
                     'style','text_edit',...
                     'string',{'Voxel size','[3 3 3]'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,0.001,0.55],...
                    },...
                    {'module_name','ReorientT1BeforeCoreg',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of T1 file','Input_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1CoregisterFun',...
                     'module_para',{'IndirT1Text','IndirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of T1 file','Input_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1CoregisterFun',...
                     'module_para',{'IndirRealignParaText','IndirRealignParaEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of EPI mean file',get_Postfix('RealignParameter')},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1CoregisterFun',...
                     'module_para',{'OutDirT1Text','OutDirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Output folder name of T1 file','Output_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','ReorientT1AfterCoreg',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of T1 file','Input_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1Segment',...
                     'module_para',{'IndirT1Text','IndirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for T1 segment','Input_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1Segment',...
                     'module_para',{'OutDirT1Text','OutDirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after T1 segment','Output_T1_folder_name'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','T1Segment',...
                     'module_para','AffineRegularisationText',...
                     'style','text',...
                     'string','Affine regularisation:',...   
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x,...
                               UserP.flexible.parameter.line3.column1.y],...
                    },...
                    {'module_name','T1Segment',...
                     'module_para','SegmentEastAsianRadio',...
                     'style','radiobutton',...
                     'string','East Asian',...   
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.2,...
                               UserP.flexible.parameter.line3.column1.y+0.01],...
                    },...
                    {'module_name','T1Segment',...
                     'module_para','SegmentEuropeanRadio',...
                     'style','radiobutton',...
                     'string','European',... 
                     'value',1,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line4.column1.x+0.2,...
                               UserP.flexible.parameter.line4.column1.y+0.03],...
                    },...
                    {'module_name','NormalizeSeg',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input EPI folder name for normalization','Input_EPI_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeSeg',...
                     'module_para',{'InDirT1Text','InDirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Input segment folder name for normalization','Input_T1_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeSeg',...
                     'module_para',{'OutFunText','OutFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after normalization','Output_EPI_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeSeg',...
                     'module_para',{'BoundingBoxText','BoundingBoxEdit'},...
                     'style','text_edit',...
                     'string',{'Bounding box','[-90,-126,-72;90,90,108]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line4.column1.x,...
                                         UserP.flexible.parameter.line4.column1.y,0.001,0.55],...
                    },...
                    {'module_name','NormalizeSeg',...
                     'module_para',{'VoxSizeText','VoxSizeEdit'},...
                     'style','text_edit',...
                     'string',{'Voxel size','[3,3,3]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input EPI folder name for normalization','Input_EPI_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'InDirT1Text','InDirT1Edit'},...
                     'style','text_edit',...
                     'string',{'Input T1 folder name for normalization','Input_T1_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'OutFunText','OutFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after normalization','Output_EPI_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'IndirRealignParaText','IndirRealignParaEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name of mean file','RealignParameter'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line4.column1.x,...
                                         UserP.flexible.parameter.line4.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'BoundingBoxText','BoundingBoxEdit'},...
                     'style','text_edit',...
                     'string',{'Bounding box','[-90,-126,-72;90,90,108]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para',{'VoxSizeText','VoxSizeEdit'},...
                     'style','text_edit',...
                     'string',{'Voxel size','[3,3,3]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line6.column1.x,...
                                         UserP.flexible.parameter.line6.column1.y,0.001,0.17],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para','AffineRegularisationText',...
                     'style','text',...
                     'string','Affine regularisation:',...   
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line6.column1.x+0.2,...
                               UserP.flexible.parameter.line6.column1.y-0.01],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para','SegmentEastAsianRadio',...
                     'style','radiobutton',...
                     'string','East Asian',...   
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line6.column1.x+0.4,...
                               UserP.flexible.parameter.line6.column1.y+0.01],...
                    },...
                    {'module_name','Normalize_newseg_dartel',...
                     'module_para','SegmentEuropeanRadio',...
                     'style','radiobutton',...
                     'string','European',... 
                     'value',1,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line7.column1.x+0.4,...
                               UserP.flexible.parameter.line7.column1.y+0.03],...
                    },...
                    {'module_name','Smooth',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for smooth','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Smooth',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after smooth','Output_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Smooth',...
                     'module_para',{'FWHMText','FWHMEdit'},...
                     'style','text_edit',...
                     'string',{'FWHM','[6 6 6]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x+0.02,...
                                         UserP.flexible.parameter.line3.column1.y,0.02,0.45],...
                    },...
                    {'module_name','Detrend',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for detrend','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Detrend',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after detrend','Output_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Filter',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for filter','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Filter',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after filter','Output_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','Filter',...
                     'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                     'style','text_edit_endash_edit',...
                     'string',{'Band(Hz)','0.01','0.08'},...
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.Parameter.Line3.X+0.02,...
                                         UserP.Parameter.Line3.Y,...
                                         0.015 0.18],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for regress','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para',{'OutdirFunText','OutdirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Output folder name after regress','Output_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para',{'PolynomialTrendText','PolynomialTrendEdit'},...
                     'style','text_edit',...
                     'string',{'Polynomial trend','1'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x+0.012,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.25],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','HeadMotion6Para',...
                     'style','checkbox',...
                     'string','6 head motion parameters',... 
                     'tag',get_GuiTag('RegressOut6HeadMotionChekbox'),...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line4.column1.x+0.012,...
                               UserP.flexible.parameter.line4.column1.y+0.015],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','GlobalMean',...
                     'style','checkbox',...
                     'string','Global mean signal',... 
                     'tag',get_GuiTag('RegressOutGlobalMeanChekbox'),...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line5.column1.x+0.012,...
                               UserP.flexible.parameter.line5.column1.y+0.035],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','WhiteMatter',...
                     'style','checkbox',...
                     'string','White matter signal',... 
                     'tag',get_GuiTag('RegressOutWhiteMatterChekbox'),...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line6.column1.x+0.012,...
                               UserP.flexible.parameter.line6.column1.y+0.055],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','CSF',...
                     'style','checkbox',...
                     'string','Cerebrospinal fluid signal',... 
                     'tag',get_GuiTag('RegressOutCSFChekbox'),...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line7.column1.x+0.012,...
                               UserP.flexible.parameter.line7.column1.y+0.075],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','add_mean_back_RadioBtn',...
                     'style','radiobutton',...
                     'string','Add mean back',... 
                     'visible','off',...
                     'value',1,...
                     'pos_xy',[UserP.flexible.parameter.line8.column1.x+0.012,...
                               UserP.flexible.parameter.line8.column1.y+0.095],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','not_add_mean_back_RadioBtn',...
                     'style','radiobutton',...
                     'string','Not add mean back',... 
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line9.column1.x+0.012,...
                               UserP.flexible.parameter.line9.column1.y+0.12],...
                    },...
                    {'module_name','RegressOutNuisance',...
                     'module_para','OtherCovariatesChekbox',...
                     'style','checkbox',...
                     'string','Other covariates',... 
                     'tag',get_GuiTag('RegressOutOtherCovariatesChekBox'),...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column2.x+0.0275,...
                               UserP.flexible.parameter.line3.column2.y],...
                    },...
                    {'module_name','RegressOutNuisance',...
                       'module_para',{'OtherCovariatesText','OtherCovariatesListbox'},...
                       'visible','off',...
                       'style','text_listbox',...
                       'string',{'Other covariates list',''},...
                       'fontsize',0.2,...
                       'pos_xy_gap_width_height',[UserP.flexible.parameter.line8.column2.x,...
                                                  UserP.flexible.parameter.line6.column2.y-0.015,...
                                                  0,...
                                                  0.24,...
                                                  0.15]},...
                    {'module_name','ALFF',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating ALFF','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','ALFF',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of ALFF',['Results' filesep 'ALFF']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...  
                    {'module_name','ALFF',...
                     'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                     'style','text_edit_endash_edit',...
                     'string',{'Band(Hz)','0.01','0.08'},...
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.Parameter.Line3.X+0.02,...
                                         UserP.Parameter.Line3.Y,...
                                         0.015 0.18],...
                    }...
                    {'module_name','fALFF',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating fALFF','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','fALFF',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of fALFF',['Results' filesep 'fALFF']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },...  
                    {'module_name','fALFF',...
                     'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                     'style','text_edit_endash_edit',...
                     'string',{'Band(Hz)','0.01','0.08'},...
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.Parameter.Line3.X+0.02,...
                                         UserP.Parameter.Line3.Y,...
                                         0.015 0.18],...
                    }...
                    {'module_name','KccReHo',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating KCC-ReHo','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','KccReHo',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of KCC-ReHo',['Results' filesep 'KCC-ReHo']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','KccReHo',...
                     'module_para','ClusterText',...
                     'style','text',...
                     'string','Cluster',... 
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.02,...
                               UserP.flexible.parameter.line3.column1.y-0.01],...
                    },... 
                    {'module_name','KccReHo',...
                     'module_para','Cluster7RadioBtn',...
                     'style','radiobutton',...
                     'string','7',... 
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.10,...
                               UserP.flexible.parameter.line3.column1.y],...
                    },... 
                    {'module_name','KccReHo',...
                     'module_para','Cluster19RadioBtn',...
                     'style','radiobutton',...
                     'string','19',... 
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.14,...
                               UserP.flexible.parameter.line3.column1.y],...
                    },... 
                    {'module_name','KccReHo',...
                     'module_para','Cluster27RadioBtn',...
                     'style','radiobutton',...
                     'string','27',... 
                     'visible','off',...
                     'value',1,...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.19,...
                               UserP.flexible.parameter.line3.column1.y],...
                    },... 
                    {'module_name','KccReHo',...
                     'module_para','SmKccReHoChekbox',...
                     'style','checkbox',...
                     'string','Smooth KCC-ReHo results',... 
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line4.column1.x+0.02,...
                               UserP.flexible.parameter.line4.column1.y],...
                    },...
                    {'module_name','KccReHo',...
                     'module_para',{'SmKccReHoFWHMtext','SmKccReHoFWHMedit'},...
                     'style','text_edit',...
                     'string',{'FWHM','[6 6 6]'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x+0.02,...
                                         UserP.flexible.parameter.line5.column1.y,0.01,0.25],...
                    },...
                    {'module_name','CoHeReHo',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating Cohe-ReHo','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','CoHeReHo',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of Cohe-ReHo',['Results' filesep 'Cohe-ReHo']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','CoHeReHo',...
                     'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                     'style','text_edit_endash_edit',...
                     'string',{'Band(Hz)','0.01','0.08'},...
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x,...
                                         UserP.flexible.parameter.line3.column1.y,...
                                         0.015 0.1],...
                    },...
                    {'module_name','CoHeReHo',...
                     'module_para','SmCoHeReHoChekbox',...
                     'style','checkbox',...
                     'string','Smooth Cohe-ReHo',...
                     'visible','off',...
                     'value',1,...
                     'pos_xy',[UserP.flexible.parameter.line4.column1.x,...
                               UserP.flexible.parameter.line4.column1.y],...
                    }...
                    {'module_name','CoHeReHo',...
                     'module_para',{'SmCoHeReHoFWHMtext','SmCoHeReHoFWHMedit'},...
                     'style','text_edit',...
                     'string',{'FWHM','[6 6 6]'},...
                     'visible','off',...
                     'value',1,...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,...
                                         0.009,0.15],...
                         }...
                    {'module_name','PerAF',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating PerAF','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','PerAF',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of PerAF',['Results' filesep 'PerAF']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','DegreeCentrality',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating degree centrality','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','DegreeCentrality',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of degree centrality',...
                               ['Results' filesep get_Postfix('DegreeCentrality')]},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','DegreeCentrality',...
                     'module_para',{'RCorrThreText','RCorrThreEdit'},...
                     'style','text_edit',...
                     'string',{'r(correlation threshold)','0.25'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x+0.015,...
                                         UserP.flexible.parameter.line3.column1.y,0.001,0.52],...
                    },... 
                    {'module_name','DegreeCentrality',...
                     'module_para','SmDegreeCentralityChekbox',...
                     'style','checkbox',...
                     'string','Smooth degree centrality',...
                     'visible','off',...
                     'value',1,...
                     'pos_xy',[UserP.flexible.parameter.line4.column1.x,...
                               UserP.flexible.parameter.line4.column1.y],...
                    }...
                    {'module_name','DegreeCentrality',...
                     'module_para',{'SmDegreeCentralityFWHMtext','SmDegreeCentralityFWHMedit'},...
                     'style','text_edit',...
                     'string',{'FWHM','[6 6 6]'},...
                     'visible','off',...
                     'value',1,...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line5.column1.x,...
                                         UserP.flexible.parameter.line5.column1.y,0.009,0.15],...
                     }...
                    {'module_name','FunConnectivity',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating FC','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','FunConnectivity',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of FC',...
                               ['Results' filesep 'FunctionalConnectivity']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','FunConnectivity',...
                     'module_para','VoxelWiseRadioBtn',...
                     'style','radiobutton',...
                     'string','Voxel wise',...
                     'tag',get_GuiTag('FunConnectivityVoxelWiseRadioBtn'),...
                     'value',1,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x,...
                               UserP.flexible.parameter.line3.column1.y],...
                    }...
                    {'module_name','FunConnectivity',...
                     'module_para','ROIWiseRadioBtn',...
                     'style','radiobutton',...
                     'string','ROI wise',...
                     'tag',get_GuiTag('FunConnectivityROIWiseRadioBtn'),...
                     'value',0,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.12,...
                               UserP.flexible.parameter.line3.column1.y],...
                    }...
                    {'module_name','FunConnectivity',...
                     'module_para','DefineROIBtn',...
                     'style','pushbutton',...
                     'string','Define ROI',...
                     'tag',get_GuiTag('FunConnectivityDefineROIBtn'),...
                     'visible','off',...
                     'pos_xy_width_height',[UserP.flexible.parameter.line4.column1.x,...
                                            UserP.flexible.parameter.line4.column1.y,...
                                            0.17,0.04],...
                    }...
                    {'module_name','FunConnectivity',...
                     'module_para',{'ROIlistText','ROIlistListbox'},...
                     'style','text_listbox',...
                     'string',{'ROI list',''},...
                     'visible','off',...
                     'fontsize',0.1,...
                     'pos_xy_gap_width_height',[UserP.flexible.parameter.line5.column1.x+0.25,...
                                                UserP.flexible.parameter.line5.column1.x,...
                                                0.001,...
                                                0.175,...
                                                0.19],...
                    }...
                    {'module_name','GCA',...
                     'module_para',{'IndirFunText','IndirFunEdit'},...
                     'style','text_edit',...
                     'string',{'Input folder name for calculating GCA','Input_folder_name'},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
                                         UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
                    },...    
                    {'module_name','GCA',...
                     'module_para',{'ResultText','ResultEdit'},...
                     'style','text_edit',...
                     'string',{'Result folder name of GCA',...
                               ['Results' filesep 'GCA']},... 
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
                                         UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
                    },... 
                    {'module_name','GCA',...
                     'module_para','VoxelWiseRadioBtn',...
                     'style','radiobutton',...
                     'string','Voxel wise',...
                     'tag',get_GuiTag('GCAVoxelWiseRadioBtn'),...
                     'value',1,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x,...
                               UserP.flexible.parameter.line3.column1.y],...
                    }...
                    {'module_name','GCA',...
                     'module_para','ROIWiseRadioBtn',...
                     'style','radiobutton',...
                     'string','ROI wise',...
                     'tag',get_GuiTag('GCAROIWiseRadioBtn'),...
                     'value',0,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line3.column1.x+0.107,...
                               UserP.flexible.parameter.line3.column1.y],...
                    }...
                    {'module_name','GCA',...
                     'module_para',{'OrderText','OrderEdit'},...
                     'style','text_edit',...
                     'string',{'Order','1'},...
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.flexible.parameter.line3.column1.x+0.21,...
                                         UserP.flexible.parameter.line3.column1.y+0.001,...
                                         0.01,0.09],...
                    }...
                    {'module_name','GCA',...
                     'module_para','DefineROIBtn',...
                     'style','pushbutton',...
                     'string','Define ROI',...
                     'tag',get_GuiTag('GCADefineROIBtn'),...
                     'visible','off',...
                     'pos_xy_width_height',[UserP.flexible.parameter.line4.column1.x,...
                                            UserP.flexible.parameter.line4.column1.y,...
                                            0.17,0.04],...
                    }...
                    {'module_name','GCA',...
                     'module_para','Coefficient_basedRadioBtn',...
                     'style','radiobutton',...
                     'string','Coefficient-based',...
                     'tag',get_GuiTag('GCACoefficient_basedRadioBtn'),...
                     'value',1,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line5.column1.x,...
                               UserP.flexible.parameter.line5.column1.y],...
                    }...
                    {'module_name','GCA',...
                     'module_para','Residual_basedRadioBtn',...
                     'style','radiobutton',...
                     'string','Residual-based',...
                     'tag',get_GuiTag('GCAResidual_basedRadioBtn'),...
                     'value',0,...
                     'visible','off',...
                     'pos_xy',[UserP.flexible.parameter.line5.column1.x+0.18,...
                               UserP.flexible.parameter.line5.column1.y],...
                    }...
                    {'module_name','GCA',...
                     'module_para','BivariateCoefficientsRadioBtn',...
                     'style','radiobutton',...
                     'string','Bivariate coefficients',...
                     'tag',get_GuiTag('GCABivariateCoefficientsRadioBtn'),...
                     'value',1,...
                     'visible','off',...
                     'enable','off',...
                     'pos_xy',[UserP.flexible.parameter.line6.column1.x,...
                               UserP.flexible.parameter.line6.column1.y+0.01],...
                    }...
                    {'module_name','GCA',...
                     'module_para','MultivariateCofficientsRadioBtn',...
                     'style','radiobutton',...
                     'string','Multivariate coefficients',...
                     'tag',get_GuiTag('GCAMultivariateCofficientsRadioBtn'),...
                     'value',0,...
                     'visible','off',...
                     'enable','off',...
                     'pos_xy',[UserP.flexible.parameter.line7.column1.x,...
                               UserP.flexible.parameter.line7.column1.y+0.0235],...
                    }...
                    {'module_name','GCA',...
                     'module_para',{'ROIlistText','ROIlistListbox'},...
                     'style','text_listbox',...
                     'fontsize',0.1,...
                     'string',{'ROI List',''},...
                     'visible','off',...
                     'pos_xy_gap_width_height',[UserP.flexible.parameter.line6.column1.x+0.4,...
                                                UserP.flexible.parameter.line6.column1.y-0.02,...
                                                0.001,...
                                                0.13,...
                                                0.2]}...

                    };
                
if_assign_style='';                
handles.hPara=draw_pipeline_UI(Preprocess_UIlist,handles.hPara,handles.MainFigure,if_assign_style);   

%slice timing
set(handles.hPara.SliceTiming.SliceOrderEdit,'callback',{@SliceOrderEdit_Callback});  


%Segment
RadioHandlesArray=[handles.hPara.T1Segment.SegmentEastAsianRadio;
                    handles.hPara.T1Segment.SegmentEuropeanRadio];  
 for i=1:length(RadioHandlesArray)                
      set(RadioHandlesArray(i),'callback',{@ParameterGUI_RadioBtnCallback,RadioHandlesArray});
 end      
 %RegressOutNuisance
  handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr=[];                        
 set(handles.hPara.RegressOutNuisance.OtherCovariatesChekbox,'callback',{@RegressOutOtherCovariates_Callback});
 
RegressOutNuisance_add_mean_back_or_not=[handles.hPara.RegressOutNuisance.add_mean_back_RadioBtn;
                                          handles.hPara.RegressOutNuisance.not_add_mean_back_RadioBtn];                  
 for i=1:length(RegressOutNuisance_add_mean_back_or_not)
      set(RegressOutNuisance_add_mean_back_or_not(i),'callback',...
         {@RegressOutNuisance_add_mean_back_or_not_Callback});
 end
 
 
 %KccReHo
  KccReHoClusterRadioBtn_Handles=[handles.hPara.KccReHo.Cluster7RadioBtn;
                                 handles.hPara.KccReHo.Cluster19RadioBtn;
                                 handles.hPara.KccReHo.Cluster27RadioBtn]; 
                             
 for i=1:length(KccReHoClusterRadioBtn_Handles)
      set(KccReHoClusterRadioBtn_Handles(i),'callback',{@KccReHoParaGUI_ClusterCallback,KccReHoClusterRadioBtn_Handles});
 end                         
 
 set(handles.hPara.KccReHo.SmKccReHoChekbox,'callback',{@KccReHoParaGUI_SmoothCallback,handles.hPara.KccReHo.SmKccReHoFWHMedit});
 
 
 % FunConnectivity
 FunConnectivityParaGUICallbackHandles= ...
                              [handles.hPara.FunConnectivity.VoxelWiseRadioBtn;
                               handles.hPara.FunConnectivity.ROIWiseRadioBtn;
                               handles.hPara.FunConnectivity.DefineROIBtn];
  
 for i=1:length(FunConnectivityParaGUICallbackHandles)
      set(FunConnectivityParaGUICallbackHandles(i),'callback',{@FunConnectivityParaGUI_Callback});
 end    
 
 % dartel_newsegment
 dartel_newsegment_RadioHandlesArray=[handles.hPara.Normalize_newseg_dartel.SegmentEastAsianRadio;
                                      handles.hPara.Normalize_newseg_dartel.SegmentEuropeanRadio];                                                                 
 for i=1:length(dartel_newsegment_RadioHandlesArray)                
      set(dartel_newsegment_RadioHandlesArray(i),'callback',...
               {@ParameterGUI_RadioBtnCallback,dartel_newsegment_RadioHandlesArray});
 end
 
 % GCA
GCAParaGUICallbackHandles= ...
                              [handles.hPara.GCA.VoxelWiseRadioBtn;
                              handles.hPara.GCA.ROIWiseRadioBtn;
                              handles.hPara.GCA.DefineROIBtn;
                              handles.hPara.GCA.Coefficient_basedRadioBtn;
                              handles.hPara.GCA.Residual_basedRadioBtn;
                              handles.hPara.GCA.BivariateCoefficientsRadioBtn;
                              handles.hPara.GCA.MultivariateCofficientsRadioBtn];
  
 for i=1:length(GCAParaGUICallbackHandles)
      set(GCAParaGUICallbackHandles(i),'callback',{@GCAParaGUI_Callback});
 end
 
 %.................
                                    

                         

%                   {'module_name','VMHC',...
%                      'module_para',{'IndirFunText','IndirFunEdit'},...
%                      'style','text_edit',...
%                      'string',{'Input folder name for calculating VMHC','folder_name_for_calculating_VMHC'},... 
%                      'visible','off',...
%                      'pos_xy_gap_width',[UserP.flexible.parameter.line1.column1.x,...
%                                          UserP.flexible.parameter.line1.column1.y,0.001,0.55],...
%                     },...    
%                     {'module_name','VMHC',...
%                      'module_para',{'ResultText','ResultEdit'},...
%                      'style','text_edit',...
%                      'string',{'Result folder name of VMHC',...
%                                ['Results' filesep get_Postfix('VMHC')]},... 
%                      'enable','off',...
%                      'visible','off',...
%                      'pos_xy_gap_width',[UserP.flexible.parameter.line2.column1.x,...
%                                          UserP.flexible.parameter.line2.column1.y,0.001,0.55],...
%                     },...                                                   

                                     

end



  

 %Callback
 %_____________________________________________________________________________
 

 
 
 function RegressOutOtherCovariates_Callback(hObject, eventdata)
 handles=guidata(gcf);         
 OtherCovariatesListboxStr=handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr;
if get(hObject,'Value')
    ROIDef=rp_ROIList_gui(OtherCovariatesListboxStr);
    OtherCovariatesListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);                       
else
    OtherCovariatesListboxStr=[];                         
end
set(handles.hPara.RegressOutNuisance.OtherCovariatesListbox,'string',OtherCovariatesListboxStr);
handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr=OtherCovariatesListboxStr;
guidata(hObject,handles);
 end 
 
 function RegressOutNuisance_add_mean_back_or_not_Callback(hObject, eventdata)
  handles=guidata(gcf);  
  RegressOutNuisance_add_mean_back_or_not=[handles.hPara.RegressOutNuisance.add_mean_back_RadioBtn;
                                          handles.hPara.RegressOutNuisance.not_add_mean_back_RadioBtn];
  RadioBtnSet(RegressOutNuisance_add_mean_back_or_not,hObject);                                    
 end
 
 
 
function KccReHoParaGUI_ClusterCallback(hObject,eventdata,KccReHoClusterRadioBtn_Handles)
    RadioBtnSet(KccReHoClusterRadioBtn_Handles,hObject);
end
 function KccReHoParaGUI_SmoothCallback(hObject,eventdata,SmKccReHoFWHMedit_handle)
    if 1== get(hObject,'value')
        set(SmKccReHoFWHMedit_handle,'enable','on');
    elseif 0==get(hObject,'value')
        set(SmKccReHoFWHMedit_handle,'enable','off');        
    end
 end
  
 
 function FunConnectivityParaGUI_Callback(hObject,eventdata)
 handles=guidata(gcf);         
CurrentTag=get(hObject,'tag');
FC_Voxewise=get_GuiTag('FunConnectivityVoxelWiseRadioBtn');
FC_ROIwise=get_GuiTag('FunConnectivityROIWiseRadioBtn');
FC_RadioBtnList=[handles.hPara.FunConnectivity.VoxelWiseRadioBtn;
                 handles.hPara.FunConnectivity.ROIWiseRadioBtn];

FC_DefineROI=get_GuiTag('FunConnectivityDefineROIBtn');

if strcmp(CurrentTag,FC_Voxewise)
   RadioBtnSet(FC_RadioBtnList,hObject);    
elseif strcmp(CurrentTag,FC_ROIwise)
   RadioBtnSet(FC_RadioBtnList,hObject);
elseif strcmp(CurrentTag,FC_DefineROI)
   ROIlistListboxStr=get(handles.hPara.FunConnectivity.ROIlistListbox,'string');
   ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);
   if isempty(ROIlistListboxCell)
       ROIlistListboxCell=[];
   end
   ROIDef=rp_ROIList_gui(ROIlistListboxCell);
   ROIlistListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);
   set(handles.hPara.FunConnectivity.ROIlistListbox,'string',ROIlistListboxStr); 
   guidata(hObject,handles);    
end
 end
 
 function ParameterGUI_RadioBtnCallback(hObject, eventdata,RadioHandlesArray)
         RadioBtnSet(RadioHandlesArray,hObject);
 end
 
  function SliceOrderEdit_Callback(hObject, eventdata)
     SliceOrder=get(hObject,'string');
     SliceOrderText =eval(['[',SliceOrder,']']);
     set(hObject,'string',num2str(SliceOrderText))
 end
 
 
 
 
 function GCAParaGUI_Callback(hObject, eventdata)
handles=guidata(gcf);

GCA_ROIwise_VoxelWise_RadioBtnArray=...
                                     [handles.hPara.GCA.VoxelWiseRadioBtn;
                                      handles.hPara.GCA.ROIWiseRadioBtn];
                                  
GCA_CoeffBased_ResiduBased_RadioBtnArray=...
                                     [handles.hPara.GCA.Coefficient_basedRadioBtn;
                                     handles.hPara.GCA.Residual_basedRadioBtn];
                                  
GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray=...
                                  [handles.hPara.GCA.BivariateCoefficientsRadioBtn;
                                   handles.hPara.GCA.MultivariateCofficientsRadioBtn];                                  
CurrentTag=get(hObject,'tag');


% Voxelwise and ROIwise
if strcmp(CurrentTag,get_GuiTag('GCAVoxelWiseRadioBtn'))  
      RadioBtnSet(GCA_ROIwise_VoxelWise_RadioBtnArray,hObject);   
      restgui_misc('BatchSetEnable',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                   'off'); 
      ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
      ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);   
      if length(ROIlistListboxCell)>1
         warndlg('GCA voxel wise only supports one ROI!  Please reselect!'); 
         set(handles.hPara.GCA.ROIlistListbox,'string',''); 
      end
elseif strcmp(CurrentTag,get_GuiTag('GCAROIWiseRadioBtn'))
      RadioBtnSet(GCA_ROIwise_VoxelWise_RadioBtnArray,hObject);  
      if 1==get(handles.hPara.GCA.Coefficient_basedRadioBtn,'value')
         restgui_misc('BatchSetEnable',...
                       GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                       'on');
      else
         restgui_misc('BatchSetEnable',...
                       GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                       'off');        
      end
end


%Define ROI pushbutton
if strcmp(CurrentTag,get_GuiTag('GCADefineROIBtn'))
    if 1==get(handles.hPara.GCA.VoxelWiseRadioBtn,'value')
        theROIDefinition=rp_SetROI;
        if ~isempty(theROIDefinition),		
            set(handles.hPara.GCA.ROIlistListbox, 'string',theROIDefinition);
        end         
    elseif 1==get(handles.hPara.GCA.ROIWiseRadioBtn,'value');
       ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
       ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);
       if isempty(ROIlistListboxCell)
           ROIlistListboxCell=[];
       end
       ROIDef=rp_ROIList_gui(ROIlistListboxCell);
       ROIlistListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);
       if 1==get(handles.hPara.GCA.Residual_basedRadioBtn,'value')
          if length(ROIDef)>2
             warndlg('GCA ROI wise(residual) only supports two ROIs!  Please reselect!');
             ROIlistListboxStr='';
          end
       end
       set(handles.hPara.GCA.ROIlistListbox,'string',ROIlistListboxStr);         
        
    else
        error('Define GCA ROI pushbutton');
    end
    
    
end

% Coefficient-based and Residual-based
if strcmp(CurrentTag,get_GuiTag('GCACoefficient_basedRadioBtn'))
   RadioBtnSet(GCA_CoeffBased_ResiduBased_RadioBtnArray,hObject); 
   if 1==get(handles.hPara.GCA.ROIWiseRadioBtn,'value')
       restgui_misc('BatchSetEnable',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                    'on');
   elseif 0==get(handles.hPara.GCA.ROIWiseRadioBtn,'value')
       restgui_misc('BatchSetEnable',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                    'off');       
   end
elseif strcmp(CurrentTag,get_GuiTag('GCAResidual_basedRadioBtn'))
   RadioBtnSet(GCA_CoeffBased_ResiduBased_RadioBtnArray,hObject); 
   restgui_misc('BatchSetEnable',...
                GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                'off'); 
   ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
   ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);   
   if length(ROIlistListboxCell)>2
      warndlg('GCA ROI wise(residual) only supports two ROIs!  Please reselect!'); 
      set(handles.hPara.GCA.ROIlistListbox,'string',''); 
   end         
end


% Bivariate coefficients and Multivariate coefficients
if strcmp(CurrentTag,get_GuiTag('GCABivariateCoefficientsRadioBtn'))...
   ||strcmp(CurrentTag,get_GuiTag('GCAMultivariateCofficientsRadioBtn'))  
   RadioBtnSet(GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,hObject);
end


end