function handles=InitGUI_BasicVersion(handles,UserP)
% initialization pipeline basic version
%------------------------------------------------------------------------------------------------------------------------------
% Input:
%     handles  -  handles of all GUI
%     UserP    -  the struct of GUI position
% Output:
%     handles  -  handles of all GUI
%-----------------------------------------------------------
%   Copyright(c) 2015
%	Center for Cognition and Brain Disorders, Hangzhou Normal University, Hangzhou 310015, China
%	Written by JIA Xi-Ze 201412
%	http://www.restfmri.net/
% 	Mail to Authors: jxz.rest@gmail.com, jiaxize@foxmail.com
%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
%   PerAF with add mean back was added by SUN Jia-Wei   20_04_24
%   dicom info was added by LI Zi-qi  210623

set(handles.MainFigure,'unit','pixels','position',[520 145 1000 670]);
set(handles.MainFigure,'Name','RESTplus');
movegui(handles.MainFigure,'center');
set(handles.UIhandles.BasicVersionRadioBtn.handle,'value',1);
set(handles.UIhandles.AdvancedVersionRadioBtn.handle,'value',0);

UserP.X=0.05;
UserP.Y=0.21;


handles=init_ui_using_uicontrol_uipanel(handles,UserP);
handles=init_other_module_ui(handles,UserP);
handles=init_preprocess_ui(handles,UserP);
handles=init_postproprocess_ui(handles,UserP);
handles=init_parameter_ui(handles,UserP);

guidata(handles.hPara.ParticipantsListInput.DisplayListbox,handles);

end

function handles=init_ui_using_uicontrol_uipanel(handles,UserP)
IfVisible='off';
handles.PreprocessUIpanel.handle= ...
                              uipanel(handles.MainFigure,...
                                      'title','Preprocessing',...
                                      'fontname','fixedwidth',...
                                      'fontweight','bold',...
                                      'fontunits','normalized',...
                                      'backgroundcolor',get(gcf,'color'),...
                                      'fontsize',0.1,...
                                      'position',[UserP.UIpanel.X,UserP.UIpanel.Y,0.536,0.215]);
                                  
handles.PostprocessUIpanel.handle= ...
                              uipanel(handles.MainFigure,...
                                      'title','Postprocessing',...
                                      'fontname','fixedwidth',...
                                      'fontweight','bold',...
                                      'fontunits','normalized',...
                                      'backgroundcolor',get(gcf,'color'),...
                                      'fontsize',0.08,...
                                      'position',[UserP.UIpanel.X,UserP.UIpanel.Y-0.25,0.536,0.215]);     
handles.ParameterUIpanel.handle= ...
                              uipanel(handles.MainFigure,...
                                      'title','Parameter',...
                                      'fontname','fixedwidth',...
                                      'fontweight','bold',...
                                      'fontunits','normalized',...
                                      'backgroundcolor',get(gcf,'color'),...
                                      'fontsize',0.065,...
                                      'position',[UserP.UIpanel.X,UserP.UIpanel.Y-0.565,0.536,0.315]); 

handles.UIhandles.DisplayParticipantsBtn.handle=....
                    uicontrol(handles.MainFigure,....
                             'style','pushbutton',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'tag',get_GuiTag('DisplayParticipantsBtn'),...
                             'string','Display participants list',...
                             'position',[UserP.DisplayParticipants.X,...
                                         UserP.DisplayParticipants.Y,...
                                         0.2,0.04]); 
handles.hPara.ParticipantsListInput.DisplayListbox=uicontrol(handles.MainFigure,'style','listbox',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'BackgroundColor',[1 1 1],...
                             'tag',get_GuiTag('DisplayParticipantsBtn'),...
                             'position',[UserP.X+0.13,UserP.Y-0.1,0.3,0.18]);

handles.hPara.ParticipantsListInput.ListboxText=uicontrol(handles.MainFigure,'style','text',...
                             'unit','normalized',...
                             'visible',IfVisible,...
                             'string','Participants',...
                             'position',[UserP.X,UserP.Y-0.05,0.1,0.04]);      
                         
                         
                         
handles.UIhandles.PreDefinedParameterPpmenu.handle=...
                    uicontrol(handles.MainFigure,....
                             'style','popupmenu',...
                             'unit','normalized',...
                             'visible','off',...
                             'BackgroundColor',[1 1 1],...
                             'FontUnits','normalized',...
                             'FontSize',0.6,...
                             'fontname','fixedwidth',...
                             'fontweight','bold',...
                             'string',[get_PreParaStr('blank') '|'...
                                       get_PreParaStr('KccReHo') '|'...
                                       get_PreParaStr('ALFF') '|'...
                                       get_PreParaStr('fALFF') '|'...
                                       get_PreParaStr('PerAF') '|' ...
                                       get_PreParaStr('DegreeCentrality') '|' ...
                                       get_PreParaStr('VMHC') '|' ...
                                       get_PreParaStr('WaveletALFF')],...%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
                             'tag',get_GuiTag('PreDefinedParameterPpmenu'),...
                             'position',[UserP.PreDefinedParameterPpmenu.X,...
                                        UserP.PreDefinedParameterPpmenu.Y,...
                                        0.46,0.04]);
                                    
handles.UIhandles.PreDefinedParameterPpmenuStr.handle=...
                    uicontrol(handles.MainFigure,....
                             'style','text',...
                             'unit','normalized',...
                             'fontname','fixedwidth',...
                             'fontweight','bold',...
                             'fontunits','normalized',...
                             'fontsize',0.8,...
                             'visible','off',...
                             'string','Shortcut',...
                             'position',[UserP.PreDefinedParameterPpmenu.X,...
                                         UserP.PreDefinedParameterPpmenu.Y+0.04,...
                                         0.08,0.027]);                          
                         
end



function handles=init_other_module_ui(handles,UserP)
% IfVisible='on';    
Preprocess_UIlist={{'module_name',{'ParameterDisplayListboxTip','ParameterDisplayListbox'},...
                    'visible','on',...
                    'style','text_listbox',...
                    'tag',{'tagdefault',get_GuiTag('ParameterDisplayListbox')},...
                    'string',{'Process list',''},...
                    'fontsize',0.04,...
                    'pos_xy_gap_width_height',[UserP.parameter_listbox.X+0.05,...
                                               UserP.parameter_listbox.Y,...
                                               0.0001,...
                                               0.35,0.8]},...                          
                    {'module_name',{'WorkDirectoryText','WorkDirectoryEdit'},...
                      'style','text_edit',...
                      'string',{'Work directory',pwd},...
                      'tag',{'defaulttag',get_GuiTag('WorkDirectoryEdit')},...
                      'pos_xy_gap_width',[UserP.WorkDirectory.X,...
                                          UserP.WorkDirectory.Y,0.016,0.385],...
                     },... 
                     {'module_name','WorkDirectoryBtn',...
                      'style','pushbutton',...
                      'string','...',...
                      'tag',get_GuiTag('WorkDirectoryBtn'),...
                      'pos_xy_width_height',[UserP.WorkDirectory.X+0.39,...
                                             UserP.WorkDirectory.Y-0.004,...
                                             0.05,0.045],...
                     },...
                     {'module_name',{'TRText','TREdit'},...
                      'style','text_edit',...
                      'string',{'TR(sec)','2'},...
                      'tag',{'defaulttag',get_GuiTag('TREdit')},...
                      'pos_xy_gap_width',[UserP.TR.X,...
                                          UserP.TR.Y,0.045,0.15],...
                     },... 
                     {'module_name','info',...
                      'style','pushbutton',...
                      'string',{'dicominfo'},...                           %   dicominfo Li Zi-Qi 210623
                      'tag',get_GuiTag('info'),...
                      'pos_xy_width_height',[UserP.pushbutton.X-0.32,...
                                          UserP.pushbutton.Y+0.887,0.08,0.04],...
                     },... 
                     {'module_name','StartDirectoryEpiCheckbox',...
                    'tag','StartDirectoryEpiCheckbox',...
                    'style','checkbox',...
                    'string','Starting EPI directory',...
                    'pos_xy',[UserP.StartDirectory.X,UserP.StartDirectory.Y],...
                    },...
                     {'module_name',{'StartDirectoryEpiText','StartDirectoryEpiEdit'},...
                      'style','text_edit',...
                      'string',{' ',''},...
                      'enable','off',...
                      'tag',{'defaulttag',get_GuiTag('StartDirectoryEpiEdit')},...
                      'pos_xy_gap_width',[UserP.StartDirectory.X+0.2,...
                                          UserP.StartDirectory.Y,...
                                          0.002,0.12],...
                     },...
                     {'module_name','StartDirectoryT1Checkbox',...
                    'tag','StartDirectoryT1Checkbox',...
                    'style','checkbox',...
                    'string','Starting T1 directory',...
                    'pos_xy',[UserP.StartDirectory.X,UserP.StartDirectory.Y-0.04],...
                    },...
                     {'module_name',{'StartDirectoryT1Text','StartDirectoryT1Edit'},...
                      'style','text_edit',...
                      'string',{' ',''},...
                      'enable','off',...
                      'tag',{'defaulttag',get_GuiTag('StartDirectoryT1Edit')},...
                      'pos_xy_gap_width',[UserP.StartDirectory.X+0.2,...
                                          UserP.StartDirectory.Y-0.04,...
                                          0.008,0.12],...
                     },...
                     {'module_name','LoadBtn',...
                      'style','pushbutton',...
                      'string','load',...
                      'tag',get_GuiTag('LoadPushBtn'),...
                      'pos_xy_width_height',[UserP.pushbutton.X,...
                                             UserP.pushbutton.Y,...
                                             0.09,0.06],...
                     },... 
                     {'module_name','SaveBtn',...
                      'style','pushbutton',...
                      'string','save',...
                      'tag',get_GuiTag('SavePushBtn'),...
                      'pos_xy_width_height',[UserP.pushbutton.X+0.12,...
                                             UserP.pushbutton.Y,...
                                             0.09,0.06],...
                     },...
                     {'module_name','RunBtn',...
                      'style','pushbutton',...
                      'string','Run',...
                      'tag',get_GuiTag('RunPushBtn'),...
                      'pos_xy_width_height',[UserP.pushbutton.X+2*0.12,...
                                            UserP.pushbutton.Y,...
                                            0.09,0.06],...
                     },...
                     {'module_name','parallel_checkbox',...
                      'style','checkbox',...
                      'string','Parallel processing ',...
                      'pos_xy',[UserP.pushbutton.X,...
                                UserP.pushbutton.Y+0.075],...
                     },...
                     {'module_name',{'parallel_text','parallel_edit'},...
                      'style','text_edit',...
                      'string',{'Workers',''},...
                      'enable','off',...
                      'pos_xy_gap_width',[UserP.pushbutton.X+0.25,...
                                          UserP.pushbutton.Y+0.07,0.01,0.13],...
                     },...
                    };
 
 



                                     

                  
                
                
                
 if_assign_style='';                               
 handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,if_assign_style); 
 
 %callback
 StartDirectory_handle_array=[handles.UIhandles.StartDirectoryT1Checkbox.handle;
                              handles.UIhandles.StartDirectoryEpiCheckbox.handle];
 for i=1:length(StartDirectory_handle_array)                         
     set(StartDirectory_handle_array(i),'callback',{@start_directory_callback,handles});
 end
 set(handles.UIhandles.parallel_checkbox.handle,'callback',{'parallel_checkbox_callback'});
 set(handles.UIhandles.parallel_edit.handle,'callback',{'parallel_edit_callback'});
 
% StopPushBtn
%                      {'module_name','StopBtn',...
%                       'style','pushbutton',...
%                       'string','Stop',...
%                       'tag',get_GuiTag('StopPushBtn'),...
%                       'pos_xy_width_height',[UserP.pushbutton.X+3*0.1,...
%                                             UserP.pushbutton.Y,...
%                                             0.09,0.06],...
%                      },...
%  set(handles.UIhandles.StopBtn.handle,'callback',{@stop_pushbutton_callback});


end                         




function handles=init_preprocess_ui(handles,UserP)

Preprocess_UIlist={{'module_name','DicomToNiftiChekbox',...
                    'tag',get_GuiTag('DicomToNiftiChekbox'),...
                    'string','1. DICOM to NIFTI',...
                    'pos_xy',[UserP.Preprocess.Line1.Column1.X,UserP.Preprocess.Line1.Y]},...
                    ...
                    {'module_name','RemoveFirstTimePointsChekbox',...
                     'tag',get_GuiTag('RemoveFirstTimePointsChekbox'),...
                     'string','2. Remove first n time points',...
                     'pos_xy',[UserP.Preprocess.Line1.Column2.X,UserP.Preprocess.Line1.Y]},...
                     ...
                    {'module_name','SliceTimingChekbox',...
                     'tag',get_GuiTag('SliceTimingChekbox'),...
                     'string','3. Slice timing',...
                     'pos_xy',[UserP.Preprocess.Line2.Column1.X,UserP.Preprocess.Line2.Y]},...
                     ...
                    {'module_name','RealignChekbox',...
                     'tag',get_GuiTag('RealignChekbox'),...
                     'string','4. Realign',...
                     'pos_xy',[UserP.Preprocess.Line2.Column2.X,UserP.Preprocess.Line2.Y]},...
                     ...
                    {'module_name','ReorientChekbox',...
                     'tag',get_GuiTag('ReorientChekbox'),...
                     'string','5. Reorient',...
                     'pos_xy',[UserP.Preprocess.Line3.Column1.X,UserP.Preprocess.Line3.Y]},...
                     ...
                    {'module_name','NormalizeChekbox',...
                     'tag',get_GuiTag('NormalizeChekbox'),...
                     'string','6. Normalize',...
                     'pos_xy',[UserP.Preprocess.Line3.Column2.X,UserP.Preprocess.Line3.Y]},... 
                     ...
                    {'module_name','SmoothChekbox',...
                     'tag',get_GuiTag('SmoothChekbox'),...
                     'string','7. Smooth',...
                     'pos_xy',[UserP.Preprocess.Line4.Column1.X,UserP.Preprocess.Line4.Y]},...
                     ...
                    {'module_name','DetrendChekbox',...
                     'tag',get_GuiTag('DetrendChekbox'),...
                     'string','8. Detrend',...
                     'pos_xy',[UserP.Preprocess.Line4.Column2.X,UserP.Preprocess.Line4.Y]},... 
                     ...
                    {'module_name','RegressOutCovariatesChekbox',...
                     'tag',get_GuiTag('RegressOutNuisanceChekbox'),...
                     'string','9.Nuisance covariates regression',...
                     'pos_xy',[UserP.Preprocess.Line5.Column1.X,UserP.Preprocess.Line5.Y]},...
                     {'module_name','FilterChekbox',...
                     'tag',get_GuiTag('FilterChekbox'),...
                     'string','10. Filter',...
                     'pos_xy',[UserP.Preprocess.Line5.Column2.X+0.116,UserP.Preprocess.Line5.Y]},...
                     ...
                     };                                 
                 
handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,'checkbox'); 


                                                                                                              
                                     
end






function handles=init_postproprocess_ui(handles,UserP)


                


Preprocess_UIlist={{'module_name','DefaultmaskRadioBtn',...
                    'tag',get_GuiTag('DefaultmaskRadioBtn'),...
                    'string','Default mask',...
                    'pos_xy',[UserP.SetMask.X,UserP.SetMask.Y],...
                    'value',1}...
                    ...
                   {'module_name','NoMaskRadioBtn',...
                    'tag',get_GuiTag('NoMaskRadioBtn'),...
                    'string','No mask',...
                    'pos_xy',[UserP.SetMask.X+0.15,UserP.SetMask.Y]}... 
                    ...
                    {'module_name','UserDefinedMaskRadioBtn',...
                    'tag',get_GuiTag('UserDefinedMaskRadioBtn'),...
                    'string','User defined mask',...
                    'pos_xy',[UserP.SetMask.X+0.3,UserP.SetMask.Y]}... 
                    ...
                    {'module_name','AlffRadioBtn',...
                    'tag',get_GuiTag('AlffRadioBtn'),...
                    'string','ALFF',...
                    'pos_xy',[UserP.Postprocess.Line1.X,UserP.Postprocess.Line1.Y]}... 
                    ...
                    {'module_name','fALFFRadioBtn',...
                    'tag',get_GuiTag('fALFFRadioBtn'),...
                    'string','fALFF',...
                    'pos_xy',[UserP.Postprocess.Line1.X+0.15,UserP.Postprocess.Line1.Y]}...
                    ...
                    {'module_name','PerAFRadioBtn',...
                    'tag',get_GuiTag('PerAFRadioBtn'),...
                    'string','PerAF',...
                    'pos_xy',[UserP.Postprocess.Line1.X+0.3,UserP.Postprocess.Line1.Y]}... 
                    ...
                    {'module_name','GBCRadioBtn',...
                    'tag',get_GuiTag('GBCRadioBtn'),...
                    'string','GBC',...
                    'pos_xy',[UserP.Postprocess.Line1.X+0.45,UserP.Postprocess.Line1.Y]}... 
                    ...
                    {'module_name','KccReHoRadioBtn',...
                    'tag',get_GuiTag('KccReHoRadioBtn'),...
                    'string','KCC-ReHo',...
                    'pos_xy',[UserP.Postprocess.Line2.X,UserP.Postprocess.Line2.Y]}... 
                    ...
                    {'module_name','CoheReHoRadioBtn',...
                    'tag',get_GuiTag('CoheReHoRadioBtn'),...
                    'string','Cohe-ReHo',...
                    'pos_xy',[UserP.Postprocess.Line2.X+0.15,UserP.Postprocess.Line2.Y]}...
                    ...
                    {'module_name','DegreeCentralityRadioBtn',...
                    'tag',get_GuiTag('DegreeCentralityRadioBtn'),...
                    'string','Degree centrality',...
                    'pos_xy',[UserP.Postprocess.Line3.X,UserP.Postprocess.Line3.Y]}...
                    ...
                    {'module_name','VMHCRadioBtn',...
                    'tag',get_GuiTag('VMHCRadioBtn'),...
                    'string','VMHC',...
                    'visible','off',...
                    'pos_xy',[UserP.Postprocess.Line3.X+0.16,UserP.Postprocess.Line3.Y]}...
                    ...
                    {'module_name','FunConnectivityRadioBtn',...
                    'tag',get_GuiTag('FunConnectivityRadioBtn'),...
                    'string','Functional connectivity',...
                    'pos_xy',[UserP.Postprocess.Line3.X+0.175,UserP.Postprocess.Line3.Y]}...
                    ...
                    {'module_name','GCARadioBtn',...
                    'tag',get_GuiTag('GCARadioBtn'),...
                    'string','GCA',...
                    'pos_xy',[UserP.Postprocess.Line3.X+0.4,UserP.Postprocess.Line3.Y]}... 
                    ...
                    {'module_name','WaveletALFFRadioBtn',...%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
                    'tag',get_GuiTag('WaveletALFFRadioBtn'),...
                    'string','Wavelet-ALFF',...
                    'pos_xy',[UserP.Postprocess.Line4.X,UserP.Postprocess.Line4.Y]}...
                    };
handles.UIhandles=draw_pipeline_UI(Preprocess_UIlist,handles.UIhandles,handles.MainFigure,'radiobutton'); 
end


                         
                         

function handles=init_parameter_ui(handles,UserP)

Preprocess_UIlist={{'module_name','DicomToNifti',...
                    'module_para','EpiChekbox',...
                    'visible','off',...
                    'style','checkbox',...
                    'string','EPI DICOM to NIFTI',...
                    'pos_xy',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y],...
                    'value',1},...
                    {'module_name','DicomToNifti',...
                    'module_para','T1Chekbox',...
                    'visible','off',...
                    'style','checkbox',...
                    'string','T1 DICOM to NIFTI',...
                    'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                    'value',1},...
                    {'module_name','RemoveTimePoints',...
                     'module_para',{'AmountText','AmountEdit'},...
                     'style','text_edit',...
                     'string',{'Remove time points number','10'},...   
                     'visible','off',...
                     'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y,0.001,0.3],...
                    },...
                    {'module_name','SliceTiming',...
                     'module_para',{'SliceNumberText','SliceNumberEdit'},...
                     'style','text_edit',...
                     'string',{'Slice number','33'},...
                     'visible','off',...
                      'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y,0.029,0.35],...
                     },...
                     {'module_name','SliceTiming',...
                      'module_para',{'SliceOrderText','SliceOrderEdit'},...
                      'style','text_edit',...
                      'string',{'Slice order',num2str(eval('[1:2:33 2:2:32]'))},...
                      'visible','off',...
                      'pos_xy_gap_width',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y,0.037,0.35],...
                      },...
                     {'module_name','SliceTiming',...
                      'module_para',{'ReferenceSliceText','ReferenceSliceEdit'},...
                      'style','text_edit',...
                      'string',{'Reference slice','33'},...
                      'visible','off',...
                      'pos_xy_gap_width',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y,0.01,0.35],...
                      },...
                      {'module_name','Reorient',...
                       'module_para','BeforeCoregiser',...
                       'visible','off',...
                       'style','radiobutton',...
                       'string','Reorient before coregister',...
                       'pos_xy',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y],...
                       'value',1},...
                       {'module_name','Reorient',...
                       'module_para','AfterCoregiser',...
                       'visible','off',...
                       'style','radiobutton',...
                       'string','Reorient after coregister',...
                       'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                       'value',0},...
                       {'module_name','Normalize',...
                       'module_para',{'BoundingBoxText','BoundingBoxEdit'},...
                       'style','text_edit',...
                       'string',{'Bounding box','[-90,-126,-72;90,90,108]'},...
                       'visible','off',...
                       'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y,0.01,0.3],...
                       },...
                       {'module_name','Normalize',...
                       'module_para',{'VoxSizeText','VoxSizeEdit'},...
                       'style','text_edit',...
                       'string',{'Voxel size','[3 3 3]'},...
                       'visible','off',...
                       'pos_xy_gap_width',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y,0.033,0.3],...
                       },...
                       {'module_name','Normalize',...
                        'module_para','EpiRadiobutton',...
                        'string','Using EPI template',...    %   NewSegment LI Zi-Qi 200502
                        'style','radiobutton',...
                        'tag',get_GuiTag('NormalizeEpiRadioBtn'),...
                        'pos_xy',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y],...
                        'visible','off',...
                        'value',1}...
                       {'module_name','Normalize',...
                        'module_para','T1segRadiobutton',...
                        'string','Using T1 image unified segmentation',...    %   NewSegment LI Zi-Qi 200502
                        'style','radiobutton',...
                        'tag',get_GuiTag('NormalizeSegRadioBtn'),...
                        'pos_xy',[UserP.Parameter.Line4.X,UserP.Parameter.Line4.Y],...
                        'visible','off',...
                        'value',0}...
                         {'module_name','Normalize',...    %   NewSegment LI Zi-Qi 200502
                        'module_para','T1NewSegRadiobutton',...
                        'string','Using T1 image new segment',...
                        'style','radiobutton',...
                        'tag',get_GuiTag('NormalizeNewSegRadioBtn'),...
                        'pos_xy',[UserP.Parameter.Line3.X+0.2,UserP.Parameter.Line3.Y],...
                        'visible','off',...
                        'value',0}...
                        {'module_name','Normalize',...
                        'module_para','T1NewSeg_dartel_Radiobutton',...
                        'string','Normalize by DARTEL using T1 image new segment',...
                        'style','radiobutton',...
                        'tag',get_GuiTag('Normalize_T1NewSeg_dartel_RadioBtn'),...
                        'pos_xy',[UserP.Parameter.Line5.X,UserP.Parameter.Line5.Y],...
                        'visible','off',...
                        'value',0}...
                        {'module_name','Normalize',...
                        'module_para','SymT1segRadiobutton',...
                        'string','Normalize to symmetric T1 template (unified segmentation)',...
                        'style','radiobutton',...
                        'tag',get_GuiTag('NormalizeSymT1segRadiobutton'),...
                        'pos_xy',[UserP.Parameter.Line6.X,UserP.Parameter.Line6.Y],...
                        'visible','off',...
                        'value',0}...
                        {'module_name','Normalize',...
                         'module_para','SegmentEastAsianRadio',...
                         'tag',get_GuiTag('SegEastAsianRadioBtn'),...
                         'string','East Asian',...
                         'style','radiobutton',...
                         'pos_xy',[UserP.Parameter.Line6.X,UserP.Parameter.Line6.Y],...
                         'visible','off',...
                        'value',0}...
                        {'module_name','Normalize',...
                         'module_para','SegmentEuropeanRadio',...
                        'string','European',...
                        'style','radiobutton',...
                        'pos_xy',[UserP.Parameter.Line6.X+0.13,UserP.Parameter.Line6.Y],...
                        'visible','off',...
                        'tag',get_GuiTag('SegEuropeanRadioBtn'),...
                        'value',1}...
                        {'module_name','Smooth',...
                         'module_para',{'FWHMText','FWHMEdit'},...
                         'style','text_edit',...
                         'string',{'FWHM','[6 6 6]'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X+0.025,UserP.Parameter.Line1.Y 0.02 0.2],...
                        },...
                        {'module_name','Filter',...
                         'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                         'style','text_edit_endash_edit',...
                         'string',{'Band(Hz)','0.01','0.08'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.015 0.1],...
                        },...
                        {'module_name','RegressOutNuisance',...
                         'module_para',{'PolynomialTrendText','PolynomialTrendEdit'},...
                         'style','text_edit',...
                         'string',{'Polynomial trend','1'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.01 0.2],...
                        },...
                        {'module_name','RegressOutNuisance',...     %   HeadMotion6Para to HeadMotionFriston24 added by LI Zi-Qi 200502
                       'module_para','HeadMotionFriston24',...
                       'visible','off',...
                       'style','checkbox',...
                       'string','Friston 24',...
                       'tag',get_GuiTag('RegressOutFrison24Chekbox'),...
                       'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','GlobalMean',...
                       'visible','off',...
                       'style','checkbox',...
                       'string','Global mean signal',...
                       'tag',get_GuiTag('RegressOutGlobalMeanChekbox'),... 
                       'pos_xy',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','WhiteMatter',...
                       'visible','off',...
                       'style','checkbox',...
                       'string','White matter signal',...
                       'tag',get_GuiTag('RegressOutWhiteMatterChekbox'),...
                       'pos_xy',[UserP.Parameter.Line4.X,UserP.Parameter.Line4.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','CSF',...
                       'visible','off',...
                       'style','checkbox',...
                       'string','Cerebrospinal fluid signal',...
                       'tag',get_GuiTag('RegressOutCSFChekbox'),... 
                       'pos_xy',[UserP.Parameter.Line5.X,UserP.Parameter.Line5.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','OtherCovariatesChekbox',...
                       'visible','off',...
                       'style','checkbox',...
                       'string','Other covariates',...
                       'tag',get_GuiTag('RegressOutOtherCovariatesChekBox'),...
                       'pos_xy',[UserP.Parameter.Line6.X,UserP.Parameter.Line6.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','add_mean_back_RadioBtn',...
                       'visible','off',...
                       'style','radiobutton',...
                       'string','add mean back',...
                       'pos_xy',[UserP.Parameter.Line7.X,UserP.Parameter.Line7.Y],...
                       'value',1},...
                       {'module_name','RegressOutNuisance',...
                       'module_para','not_add_mean_back_RadioBtn',...
                       'visible','off',...
                       'style','radiobutton',...
                       'string','not add mean back',...
                       'pos_xy',[UserP.Parameter.Line7.X+0.15,UserP.Parameter.Line7.Y],...
                       'value',0},...
                       {'module_name','RegressOutNuisance',...
                       'module_para',{'OtherCovariatesText','OtherCovariatesListbox'},...
                       'visible','off',...
                       'style','text_listbox',...
                       'string',{'Other covariates',''},...
                       'fontsize',0.1,...
                       'pos_xy_gap_width_height',[UserP.Parameter.Line5.X+0.25,...
                                                  UserP.Parameter.Line5.Y,...
                                                  0.001,...
                                                  0.175,...
                                                  0.19]},...
                       {'module_name','ALFF',...
                         'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                         'style','text_edit_endash_edit',...
                         'string',{'Band(Hz)','0.01','0.08'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.015 0.1],...
                        },...
                        {'module_name','fALFF',...
                         'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                         'style','text_edit_endash_edit',...
                         'string',{'Band(Hz)','0.01','0.08'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.015 0.1],...
                        },...
                        {'module_name','KccReHo',...
                         'module_para','ClusterText',...
                         'style','text',...
                         'string','Cluster',...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y-0.007],...
                        }...
                        {'module_name','KccReHo',...
                         'module_para','Cluster7RadioBtn',...
                         'style','radiobutton',...
                         'string','7',...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X+0.07,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','KccReHo',...
                         'module_para','Cluster19RadioBtn',...
                         'style','radiobutton',...
                         'string','19',...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X+0.11,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','KccReHo',...
                         'module_para','Cluster27RadioBtn',...
                         'style','radiobutton',...
                         'string','27',...
                         'visible','off',...
                         'value',1,...
                         'pos_xy',[UserP.Parameter.Line1.X+0.16,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','KccReHo',...
                         'module_para','SmKccReHoChekbox',...
                         'style','checkbox',...
                         'string','Smooth KCC-ReHo',...
                         'visible','off',...
                         'value',1,...
                         'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                        }...
                        {'module_name','KccReHo',...
                         'module_para',{'SmKccReHoFWHMtext','SmKccReHoFWHMedit'},...
                         'style','text_edit',...
                         'string',{'FWHM','[6 6 6]'},...
                         'visible','off',...
                         'value',1,...
                         'pos_xy_gap_width',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y,0.009,0.15],...
                        }...
                        {'module_name','DegreeCentrality',...
                         'module_para',{'RCorrThreText','RCorrThreEdit'},...
                         'style','text_edit',...
                         'string',{'r(correlation threshold):','0.25'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y,0.002,0.3],...
                        }...
                        {'module_name','DegreeCentrality',...
                         'module_para','SmDegreeCentralityChekbox',...
                         'style','checkbox',...
                         'string','Smooth degree centrality',...
                         'visible','off',...
                         'value',1,...
                         'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                        }...
                        {'module_name','DegreeCentrality',...
                         'module_para',{'SmDegreeCentralityFWHMtext','SmDegreeCentralityFWHMedit'},...
                         'style','text_edit',...
                         'string',{'FWHM','[6 6 6]'},...
                         'visible','off',...
                         'value',1,...
                         'pos_xy_gap_width',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y,0.009,0.15],...
                         }...
                        {'module_name','FunConnectivity',...
                         'module_para','VoxelWiseRadioBtn',...
                         'style','radiobutton',...
                         'string','Voxel wise',...
                         'tag',get_GuiTag('FunConnectivityVoxelWiseRadioBtn'),...
                         'value',1,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','FunConnectivity',...
                         'module_para','ROIWiseRadioBtn',...
                         'style','radiobutton',...
                         'string','ROI wise',...
                         'tag',get_GuiTag('FunConnectivityROIWiseRadioBtn'),...
                         'value',0,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X+0.12,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','FunConnectivity',...
                         'module_para','DefineROIBtn',...
                         'style','pushbutton',...
                         'string','Define ROI',...
                         'tag',get_GuiTag('FunConnectivityDefineROIBtn'),...
                         'visible','off',...
                         'pos_xy_width_height',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y 0.17 0.04],...
                        }...
                        {'module_name','FunConnectivity',...
                         'module_para',{'ROIlistText','ROIlistListbox'},...
                         'style','text_listbox',...
                         'string',{'ROI list',''},...
                         'visible','off',...
                         'fontsize',0.1,...
                         'pos_xy_gap_width_height',[UserP.Parameter.Line5.X+0.25,...
                                                    UserP.Parameter.Line5.Y,...
                                                    0.001,...
                                                    0.175,...
                                                    0.19],...
                        }...
                        {'module_name','CoHeReHo',...
                         'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                         'style','text_edit_endash_edit',...
                         'string',{'Band(Hz)','0.01','0.08'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.015 0.1],...
                        },...
                        {'module_name','CoHeReHo',...
                         'module_para','SmCoHeReHoChekbox',...
                         'style','checkbox',...
                         'string','Smooth Cohe-ReHo',...
                         'visible','off',...
                         'value',1,...
                         'pos_xy',[UserP.Parameter.Line2.X,UserP.Parameter.Line2.Y],...
                        }...
                        {'module_name','CoHeReHo',...
                         'module_para',{'SmCoHeReHoFWHMtext','SmCoHeReHoFWHMedit'},...
                         'style','text_edit',...
                         'string',{'FWHM','[6 6 6]'},...
                         'visible','off',...
                         'value',1,...
                         'pos_xy_gap_width',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y,0.009,0.15],...
                         }...
                        {'module_name','GCA',...
                         'module_para','VoxelWiseRadioBtn',...
                         'style','radiobutton',...
                         'string','Voxel wise',...
                         'tag',get_GuiTag('GCAVoxelWiseRadioBtn'),...
                         'value',1,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para','ROIWiseRadioBtn',...
                         'style','radiobutton',...
                         'string','ROI wise',...
                         'tag',get_GuiTag('GCAROIWiseRadioBtn'),...
                         'value',0,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line1.X+0.107,UserP.Parameter.Line1.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para',{'OrderText','OrderEdit'},...
                         'style','text_edit',...
                         'string',{'Order','1'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line2.X,...
                                             UserP.Parameter.Line2.Y+0.001,0.01,0.15],...
                        }...
                        {'module_name','GCA',...
                         'module_para','DefineROIBtn',...
                         'style','pushbutton',...
                         'string','Define ROI',...
                         'tag',get_GuiTag('GCADefineROIBtn'),...
                         'visible','off',...
                         'pos_xy_width_height',[UserP.Parameter.Line3.X,UserP.Parameter.Line3.Y 0.17 0.04],...
                        }...
                        {'module_name','GCA',...
                         'module_para','Coefficient_basedRadioBtn',...
                         'style','radiobutton',...
                         'string','Coefficient-based',...
                         'tag',get_GuiTag('GCACoefficient_basedRadioBtn'),...
                         'value',1,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line4.X,UserP.Parameter.Line4.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para','Residual_basedRadioBtn',...
                         'style','radiobutton',...
                         'string','Residual-based',...
                         'tag',get_GuiTag('GCAResidual_basedRadioBtn'),...
                         'value',0,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line4.X+0.165,UserP.Parameter.Line4.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para','BivariateCoefficientsRadioBtn',...
                         'style','radiobutton',...
                         'string','Bivariate coefficients',...
                         'tag',get_GuiTag('GCABivariateCoefficientsRadioBtn'),...
                         'value',1,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line5.X,UserP.Parameter.Line5.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para','MultivariateCofficientsRadioBtn',...
                         'style','radiobutton',...
                         'string','Multivariate coefficients',...
                         'tag',get_GuiTag('GCAMultivariateCofficientsRadioBtn'),...
                         'value',0,...
                         'visible','off',...
                         'pos_xy',[UserP.Parameter.Line6.X,UserP.Parameter.Line6.Y],...
                        }...
                        {'module_name','GCA',...
                         'module_para',{'ROIlistText','ROIlistListbox'},...
                         'style','text_listbox',...
                         'fontsize',0.1,...
                         'string',{'ROI List',''},...
                         'visible','off',...
                         'pos_xy_gap_width_height',[UserP.Parameter.Line5.X+0.33,...
                                                    UserP.Parameter.Line5.Y-0.02,...
                                                    0.001,...
                                                    0.136,...
                                                    0.223],...
                        }...
                        {'module_name','WaveletALFF',...
                         'module_para',{'BandText','BandLowEdit','BandSepText','BandHighEdit'},...
                         'style','text_edit_endash_edit',...
                         'string',{'Band(Hz)','0.01','0.08'},...
                         'visible','off',...
                         'pos_xy_gap_width',[UserP.Parameter.Line1.X,UserP.Parameter.Line1.Y 0.015 0.1],...
                        },...%   Wavelet-ALFF was added by SUN Jia-Wei   20_04_20
                       };
                                     

                   
                                     


                                     
if_assign_style='';                
handles.hPara=draw_pipeline_UI(Preprocess_UIlist,handles.hPara,handles.MainFigure,if_assign_style); 


% SliceTiming
set(handles.hPara.SliceTiming.SliceOrderEdit,'callback',{@SliceOrderEdit_Callback});  

%Reorient
ReorientParaGUICallbackHandles=[handles.hPara.Reorient.BeforeCoregiser;
                                handles.hPara.Reorient.AfterCoregiser];
 for i=1:length(ReorientParaGUICallbackHandles)
      set(ReorientParaGUICallbackHandles(i),'callback',{@ReorientParaGUI_Callback,handles});
 end

% Normalize
NormalizeParaGUICallbackHandles=[handles.hPara.Normalize.EpiRadiobutton;
                               handles.hPara.Normalize.T1segRadiobutton;
                               handles.hPara.Normalize.SymT1segRadiobutton;
                               handles.hPara.Normalize.T1NewSegRadiobutton;%   NewSegment LI Zi-Qi 200502
                               handles.hPara.Normalize.T1NewSeg_dartel_Radiobutton;
                               handles.hPara.Normalize.SegmentEastAsianRadio;
                               handles.hPara.Normalize.SegmentEuropeanRadio];
                           
 for i=1:length(NormalizeParaGUICallbackHandles)
      set(NormalizeParaGUICallbackHandles(i),'callback',{@NormalizeParaGUI_Callback,handles});
 end
 
 % RegressOutNuisance
 handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr=[];    
 set(handles.hPara.RegressOutNuisance.OtherCovariatesChekbox,'callback',{@RegressOutOtherCovariates_Callback});
 
 RegressOutNuisance_add_mean_back_or_not=[handles.hPara.RegressOutNuisance.add_mean_back_RadioBtn;
                                          handles.hPara.RegressOutNuisance.not_add_mean_back_RadioBtn];                  
 for i=1:length(RegressOutNuisance_add_mean_back_or_not)
      set(RegressOutNuisance_add_mean_back_or_not(i),'callback',...
         {@RegressOutNuisance_add_mean_back_or_not_Callback});
 end


 
 % KccReHo
  KccReHoClusterRadioBtn_Handles=[handles.hPara.KccReHo.Cluster7RadioBtn;
                                 handles.hPara.KccReHo.Cluster19RadioBtn;
                                 handles.hPara.KccReHo.Cluster27RadioBtn]; 
                             

 for i=1:length(KccReHoClusterRadioBtn_Handles)
      set(KccReHoClusterRadioBtn_Handles(i),'callback',{@KccReHoParaGUI_ClusterCallback,KccReHoClusterRadioBtn_Handles});
 end    
 set(handles.hPara.KccReHo.SmKccReHoChekbox,'callback',{@KccReHoParaGUI_SmoothCallback,handles.hPara.KccReHo.SmKccReHoFWHMedit});
 
 
 
 % FunConnectivity
 FunConnectivityParaGUICallbackHandles= ...
                              [handles.hPara.FunConnectivity.VoxelWiseRadioBtn;
                               handles.hPara.FunConnectivity.ROIWiseRadioBtn;
                               handles.hPara.FunConnectivity.DefineROIBtn];
  
 for i=1:length(FunConnectivityParaGUICallbackHandles)
      set(FunConnectivityParaGUICallbackHandles(i),'callback',{@FunConnectivityParaGUI_Callback});
 end          
 
% GCA
GCAParaGUICallbackHandles= ...
                              [handles.hPara.GCA.VoxelWiseRadioBtn;
                              handles.hPara.GCA.ROIWiseRadioBtn;
                              handles.hPara.GCA.DefineROIBtn;
                              handles.hPara.GCA.Coefficient_basedRadioBtn;
                              handles.hPara.GCA.Residual_basedRadioBtn;
                              handles.hPara.GCA.BivariateCoefficientsRadioBtn;
                              handles.hPara.GCA.MultivariateCofficientsRadioBtn];
  
 for i=1:length(GCAParaGUICallbackHandles)
      set(GCAParaGUICallbackHandles(i),'callback',{@GCAParaGUI_Callback});
 end
 
end



%_________________________________________________________________________________________________________
%_________________________________________________________________________________________________________
%_________________________________________________________________________________________________________
% Callback 
function start_directory_callback(hObject, eventdata,handles)
current_tag=get(hObject,'tag');

if strcmp(current_tag,'StartDirectoryT1Checkbox')
   if 1==get(hObject,'value')
      set(handles.UIhandles.StartDirectoryT1Edit.handle,'enable','on'); 
   else
      set(handles.UIhandles.StartDirectoryT1Edit.handle,'enable','off');  
   end
elseif strcmp(current_tag,'StartDirectoryEpiCheckbox')
   if 1==get(hObject,'value')
       set(handles.UIhandles.StartDirectoryEpiEdit.handle,'enable','on'); 
   else
       set(handles.UIhandles.StartDirectoryEpiEdit.handle,'enable','off'); 
   end    
end

end
function stop_pushbutton_callback(hObject, eventdata)
handles=guidata(gcf);
% If_stop_the_program= questdlg('Do you want stop the program?',...
%                               'Stop','Yes','No','No');  
                                
% if strcmpi(If_stop_the_program,'Yes')
    
    
    set(handles.UIhandles.RunBtn.handle,'enable','on',...
        'BackgroundColor',get(hObject,'BackgroundColor'),...
        'ForegroundColor',get(hObject,'ForegroundColor'));
    program_interrupt();
%     error('Program terminated for a specific reason!');
% end


end







 
 
 function SliceOrderEdit_Callback(hObject, eventdata)
     SliceOrder=get(hObject,'string');
     SliceOrderText =eval(['[',SliceOrder,']']);
     set(hObject,'string',num2str(SliceOrderText))
 end

 
 function ReorientParaGUI_Callback(hObject, eventdata,handles)
 ReorientParaGUICallbackHandles=[handles.hPara.Reorient.BeforeCoregiser;
                                handles.hPara.Reorient.AfterCoregiser];
 RadioBtnSet(ReorientParaGUICallbackHandles,hObject);                                                      
 end
                       
 
 function NormalizeParaGUI_Callback(hObject, eventdata,handles)
 NormalizeTypeHandles=[handles.hPara.Normalize.T1segRadiobutton;
                       handles.hPara.Normalize.EpiRadiobutton;
                       handles.hPara.Normalize.T1NewSeg_dartel_Radiobutton;
                       handles.hPara.Normalize.T1NewSegRadiobutton;
                       handles.hPara.Normalize.SymT1segRadiobutton];
                   
 SegmentTypeHandles=[handles.hPara.Normalize.SegmentEastAsianRadio;
                     handles.hPara.Normalize.SegmentEuropeanRadio]; 
 CurrentTag=get(hObject,'tag');
 
 NormEpiTag=get_GuiTag('NormalizeEpiRadioBtn');
 NormSegTag=get_GuiTag('NormalizeSegRadioBtn');
 NormNewTag=get_GuiTag('NormalizeNewSegRadioBtn');%   NewSegment LI Zi-Qi 200502
 NormSymSegTag=get_GuiTag('NormalizeSymT1segRadiobutton');
 NormDartelNewSeg=get_GuiTag('Normalize_T1NewSeg_dartel_RadioBtn');
 EastAsianTag=get_GuiTag('SegEastAsianRadioBtn');
 EuropeanTag=get_GuiTag('SegEuropeanRadioBtn');

  if strcmp(CurrentTag,NormEpiTag)...
     ||strcmp(CurrentTag,NormSegTag)...
     ||strcmp(CurrentTag,NormDartelNewSeg)...
     ||strcmp(CurrentTag,NormSymSegTag)...
     ||strcmp(CurrentTag,NormNewTag)%   NewSegment LI Zi-Qi 200502
      RadioBtnSet(NormalizeTypeHandles,hObject);
  elseif strcmp(CurrentTag,EastAsianTag)||strcmp(CurrentTag,EuropeanTag)
      RadioBtnSet(SegmentTypeHandles,hObject);      
  end
  
 for i=1:length(SegmentTypeHandles)
      if strcmp(CurrentTag,NormEpiTag)
         set(SegmentTypeHandles(i),'visible','off');
      elseif strcmp(CurrentTag,NormSegTag)...
             ||strcmp(CurrentTag,NormDartelNewSeg)... 
             ||strcmp(CurrentTag,NormSymSegTag)...
             ||strcmp(CurrentTag,NormNewTag)%   NewSegment LI Zi-Qi 200502
         set(SegmentTypeHandles(i),'visible','on');
      end
 end
                       

end                         
                         
 
 
 function RegressOutOtherCovariates_Callback(hObject, eventdata)
 handles=guidata(gcf);         
 OtherCovariatesListboxStr=handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr;
if get(hObject,'Value')
    ROIDef=rp_ROIList_gui(OtherCovariatesListboxStr);
    OtherCovariatesListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);                       
else
    OtherCovariatesListboxStr=[];                         
end
set(handles.hPara.RegressOutNuisance.OtherCovariatesListbox,'string',OtherCovariatesListboxStr);
handles.UIvalue.RegressOutNuisance.OtherCovariatesListboxStr=OtherCovariatesListboxStr;
guidata(hObject,handles);
 end
 
 
 function RegressOutNuisance_add_mean_back_or_not_Callback(hObject, eventdata)
  handles=guidata(gcf);  
  RegressOutNuisance_add_mean_back_or_not=[handles.hPara.RegressOutNuisance.add_mean_back_RadioBtn;
                                          handles.hPara.RegressOutNuisance.not_add_mean_back_RadioBtn];
  RadioBtnSet(RegressOutNuisance_add_mean_back_or_not,hObject);     
  restgui_misc('check_if_addmeanback_withperaf');% PerAF with add mean back was added by SUN Jia-Wei   20_04_24
 end
 

function KccReHoParaGUI_ClusterCallback(hObject,eventdata,KccReHoClusterRadioBtn_Handles)
RadioBtnSet(KccReHoClusterRadioBtn_Handles,hObject);
end
 


function KccReHoParaGUI_SmoothCallback(hObject,eventdata,SmKccReHoFWHMedit_handle)
    if 1== get(hObject,'value')
        set(SmKccReHoFWHMedit_handle,'enable','on');
    elseif 0==get(hObject,'value')
        set(SmKccReHoFWHMedit_handle,'enable','off');        
    end
        
end
 

                      



function FunConnectivityParaGUI_Callback(hObject, eventdata)
handles=guidata(gcf);         
CurrentTag=get(hObject,'tag');
FC_Voxewise=get_GuiTag('FunConnectivityVoxelWiseRadioBtn');
FC_ROIwise=get_GuiTag('FunConnectivityROIWiseRadioBtn');
FC_RadioBtnList=[handles.hPara.FunConnectivity.VoxelWiseRadioBtn;
                 handles.hPara.FunConnectivity.ROIWiseRadioBtn];

FC_DefineROI=get_GuiTag('FunConnectivityDefineROIBtn');

if strcmp(CurrentTag,FC_Voxewise)
   RadioBtnSet(FC_RadioBtnList,hObject);    
elseif strcmp(CurrentTag,FC_ROIwise)
   RadioBtnSet(FC_RadioBtnList,hObject);
elseif strcmp(CurrentTag,FC_DefineROI)
   ROIlistListboxStr=get(handles.hPara.FunConnectivity.ROIlistListbox,'string');
   ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);
   if isempty(ROIlistListboxCell)
       ROIlistListboxCell=[];
   end
   ROIDef=rp_ROIList_gui(ROIlistListboxCell);
   ROIlistListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);
   set(handles.hPara.FunConnectivity.ROIlistListbox,'string',ROIlistListboxStr); 
   guidata(hObject,handles);    
end
end






function GCAParaGUI_Callback(hObject, eventdata)
handles=guidata(gcf);

GCA_ROIwise_VoxelWise_RadioBtnArray=...
                                     [handles.hPara.GCA.VoxelWiseRadioBtn;
                                      handles.hPara.GCA.ROIWiseRadioBtn];
                                  
GCA_CoeffBased_ResiduBased_RadioBtnArray=...
                                     [handles.hPara.GCA.Coefficient_basedRadioBtn;
                                     handles.hPara.GCA.Residual_basedRadioBtn];
                                  
GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray=...
                                  [handles.hPara.GCA.BivariateCoefficientsRadioBtn;
                                   handles.hPara.GCA.MultivariateCofficientsRadioBtn];                                  
CurrentTag=get(hObject,'tag');


% Voxelwise and ROIwise
if strcmp(CurrentTag,get_GuiTag('GCAVoxelWiseRadioBtn'))  
      RadioBtnSet(GCA_ROIwise_VoxelWise_RadioBtnArray,hObject);   
      restgui_misc('BatchSetVisible',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                   'off'); 
      ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
      ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);   
      if length(ROIlistListboxCell)>1
         warndlg('GCA voxel wise only supports one ROI!  Please reselect!'); 
         set(handles.hPara.GCA.ROIlistListbox,'string',''); 
      end
elseif strcmp(CurrentTag,get_GuiTag('GCAROIWiseRadioBtn'))
      RadioBtnSet(GCA_ROIwise_VoxelWise_RadioBtnArray,hObject);  
      if 1==get(handles.hPara.GCA.Coefficient_basedRadioBtn,'value')
         restgui_misc('BatchSetVisible',...
                       GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                       'on');
      else
         restgui_misc('BatchSetVisible',...
                       GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                       'off');        
      end
end


%Define ROI pushbutton
if strcmp(CurrentTag,get_GuiTag('GCADefineROIBtn'))
    if 1==get(handles.hPara.GCA.VoxelWiseRadioBtn,'value')
        theROIDefinition=rp_SetROI;
        if ~isempty(theROIDefinition),		
            set(handles.hPara.GCA.ROIlistListbox, 'string',theROIDefinition);
        end         
    elseif 1==get(handles.hPara.GCA.ROIWiseRadioBtn,'value');
       ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
       ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);
       if isempty(ROIlistListboxCell)
           ROIlistListboxCell=[];
       end
       ROIDef=rp_ROIList_gui(ROIlistListboxCell);
       ROIlistListboxStr=brief_misc('CellArray2Listboxstr',ROIDef);
       if 1==get(handles.hPara.GCA.Residual_basedRadioBtn,'value')
          if length(ROIDef)>2
             warndlg('GCA ROI wise(residual) only supports two ROIs!  Please reselect!');
             ROIlistListboxStr='';
          end
       end
       set(handles.hPara.GCA.ROIlistListbox,'string',ROIlistListboxStr);         
        
    else
        error('Define GCA ROI pushbutton');
    end
    
    
end

% Coefficient-based and Residual-based
if strcmp(CurrentTag,get_GuiTag('GCACoefficient_basedRadioBtn'))
   RadioBtnSet(GCA_CoeffBased_ResiduBased_RadioBtnArray,hObject); 
   if 1==get(handles.hPara.GCA.ROIWiseRadioBtn,'value')
       restgui_misc('BatchSetVisible',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                    'on');
   elseif 0==get(handles.hPara.GCA.ROIWiseRadioBtn,'value')
       restgui_misc('BatchSetVisible',...
                    GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                    'off');       
   end
elseif strcmp(CurrentTag,get_GuiTag('GCAResidual_basedRadioBtn'))
   RadioBtnSet(GCA_CoeffBased_ResiduBased_RadioBtnArray,hObject); 
   restgui_misc('BatchSetVisible',...
                GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,...
                'off'); 
   ROIlistListboxStr=get(handles.hPara.GCA.ROIlistListbox,'string');
   ROIlistListboxCell=brief_misc('ListboxStr2CellArray',ROIlistListboxStr);   
   if length(ROIlistListboxCell)>2
      warndlg('GCA ROI wise(residual) only supports two ROIs!  Please reselect!'); 
      set(handles.hPara.GCA.ROIlistListbox,'string',''); 
   end         
end


% Bivariate coefficients and Multivariate coefficients
if strcmp(CurrentTag,get_GuiTag('GCABivariateCoefficientsRadioBtn'))...
   ||strcmp(CurrentTag,get_GuiTag('GCAMultivariateCofficientsRadioBtn'))  
   RadioBtnSet(GCA_ROIWISE_BivaCoeff_MultiCoeff_RadioBtnArray,hObject);
end


end



