function infodr_GBC(AllVolume, outfile_GBC, infilepath_Mask)
    rp_GBC(AllVolume, outfile_GBC, infilepath_Mask);
end

function rp_GBC(AllVolume, AResultFilename, infile_Mask)
    theElapsedTime = cputime;
    CUTNUMBER = 300;
    if ~isnumeric(AllVolume)
        [AllVolume, vsize, theImgFileList, Header] =rp_to4d(AllVolume);
    end

    [nDim1 nDim2 nDim3 nDimTimePoints]=size(AllVolume);
    AllVolume=reshape(AllVolume,[],nDimTimePoints)';
    MaskData=rp_loadmask(nDim1, nDim2, nDim3, infile_Mask);
    MaskDataOneDim=reshape(MaskData,1,[]);
    MaskIndex = find(MaskDataOneDim);
    AllVolume=AllVolume(:,MaskIndex);
    AllVolume = (AllVolume-repmat(mean(AllVolume),size(AllVolume,1),1))./repmat(std(AllVolume),size(AllVolume,1),1);
    AllVolume(isnan(AllVolume))=0;
    tmp_fc = zeros(length(MaskIndex),1);

    SegmentLength = ceil(size(AllVolume,2) / CUTNUMBER);
    CUTNUMBER = ceil(size(AllVolume,2) / SegmentLength);

    % for i=1:size(AllVolume,2)
    %     for j=1:size(AllVolume,2)
    %          tmp_fc(1,j)=corr(AllVolume(:,i),AllVolume(:,j));
    %     end
    %     tmp_fc(isnan(tmp_fc))=0;
    %     ztmp_fc=(0.5 * log((1 + tmp_fc)./(1 - tmp_fc)));
    %     ztmp_fc(isinf(ztmp_fc))=0;
    %     ztmp(i,:)=sum(ztmp_fc,2)/(size(AllVolume,2)-1);
    % end

    for iCut=1:CUTNUMBER
        if iCut~=CUTNUMBER
            Segment = (iCut-1)*SegmentLength+1 : iCut*SegmentLength;
        else
            Segment = (iCut-1)*SegmentLength+1 : size(AllVolume,2);
        end
        tmp = AllVolume(:,Segment)'*AllVolume/(nDimTimePoints-1);
        tmp=roundn(tmp,-10);
        tmp(tmp==1)=0;
        ztmp=(0.5 * log((1 + tmp)./(1 - tmp)));
        tmp_fc(Segment)=sum(ztmp,2)./(size(AllVolume,2)-1);
        fprintf('.');
    end
    fprintf('\n');
    tmp_fc=tmp_fc';
    GBCresults=zeros(1,length(MaskDataOneDim));
    GBCresults(1,find(MaskDataOneDim))=tmp_fc;
    GBCresults=reshape(GBCresults,nDim1,nDim2,nDim3);
    rp_WriteNiftiImage(GBCresults, Header, AResultFilename);
    
    fprintf('\n');
    theElapsedTime = cputime - theElapsedTime;
    fprintf('\n\t GBC compution over, elapsed time: %g seconds.\n', theElapsedTime);
end